export const context = {
    services: {
        refill: {
            alias: 'refill',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/998550/3b095c224131ca8faa87bfec5099a480c1fda911/svg',
            ids: {},
            name: 'Заправки',
            i18nKeyName: 'refill',
            url: 'https://zapravki.yandex.ru/',
            help: 'https://yandex.ru/chat#/user/3d8f0007-f610-914e-45f7-3eddaf3cc441',
        },
        plus_360: {
            alias: 'plus_360',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/994123/49ef2ec62be2f58b5f765b12cdfd9a04dd826e0e/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/994123/e4a8e3d3f8810a4cbebed1fc7f8952bd5df8d870/orig',
            ids: {},
            name: 'Подписка Яндекс 360',
            i18nKeyName: 'plus_360',
            url: 'https://mail360.yandex.ru',
            help: 'https://yandex.ru/support/mail/yandex-360.html',
        },
        praktikum: {
            alias: 'praktikum',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/994123/2029eb942ed84255579609bdd006f29bd6710d75/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/118781/57dd72c90f5871728407efd8c1e14495fee46761/orig',
            ids: {},
            name: 'Практикум',
            i18nKeyName: 'praktikum',
            url: 'https://practicum.yandex.ru/',
            help: 'https://yandex.ru/support/praktikum/feedback.html',
        },
        travel: {
            alias: 'travel',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/61205/e18dfaf6ae7e62e4a3be97bfd77e57ef33541404/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/994123/e1b838d55b6d1640a31323774f4f5a77a349766e/orig',
            ids: {},
            name: 'Путешествия',
            i18nKeyName: 'travel',
            url: 'https://travel.yandex.ru/hotels/',
            help: 'https://yandex.ru/support/travel/troubleshooting.html',
        },
        market: {
            alias: 'market',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/998550/ae1b6a5e3bd6905ee694fedc593e6ac497fee0e2/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/56833/35e70a852d59a7bd9c229bbf7d943f9155e65948/orig',
            ids: {},
            name: 'Маркет',
            i18nKeyName: 'market',
            url: 'https://pokupki.market.yandex.ru/my/orders',
        },
        afisha: {
            alias: 'afisha',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/128809/d4f71a94e2abd037b9e3862eca8824f6188ce7a9/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/60661/ea8ff7736616b4920852a9d4fc937fb2bbf8b8b8/orig',
            ids: {},
            name: 'Афиша',
            i18nKeyName: 'afisha',
            url: 'https://afisha.yandex.ru/',
        },
        kinopoisk: {
            alias: 'kinopoisk',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/49769/3c8752854e2d9fb4145b9a995cab8017321d774d/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/49769/e4070af0aefcd6fe2170ff14dbe5e58bad3e97d1/orig',
            ids: {},
            name: 'КиноПоиск',
            i18nKeyName: 'kinopoisk',
            url: 'https://hd.kinopoisk.ru/purchases',
        },
        plus: {
            alias: 'plus',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/e425107fb2cf831e2043b8a0ec86ae69835c3439/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/56833/fc16b55a67977c0dd19bfcb626e22ce83670ca93/svg',
            ids: {},
            name: 'Плюс',
            i18nKeyName: 'plus',
        },
        help_nko: {
            alias: 'help_nko',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/49769/b151a0f4a3796df437ebb45d913a4078289a8a7b/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/128809/6bf5ba7f303e3a6285667d61378b3133d1321a62/orig',
            ids: {},
            name: 'Помощь рядом',
            i18nKeyName: 'help_nearby',
            url: 'https://help.yandex.ru/roundup',
        },
        pay: {
            alias: 'pay',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/e425107fb2cf831e2043b8a0ec86ae69835c3439/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/56833/fc16b55a67977c0dd19bfcb626e22ce83670ca93/svg',
            ids: {},
            name: 'Pay',
            i18nKeyName: 'pay',
        },
        uslugi: {
            alias: 'uslugi',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/9da97fa2062af980929974de64343d47f49f72e8/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/998550/15a34c77fe975dabfe58f39f4e882d5ecc103d9e/orig',
            ids: {},
            name: 'Услуги',
            i18nKeyName: 'uslugi',
            url: 'https://uslugi.yandex.ru/my-orders',
            help: 'https://yandex.ru/chat#/user/3ea8c303-761b-9ce6-7a27-1a6cafa572f2',
        },
        lavka: {
            alias: 'lavka',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/49769/ae04ac827389ecf6786984250872830981ca4659/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/50064/908b53b0849408ce580da95a801c9a9ee130e255/orig',
            ids: {},
            name: 'Лавка',
            i18nKeyName: 'lavka',
            url: 'https://lavka.yandex.ru',
        },
        drive: {
            alias: 'drive',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/49769/622ce19ef4e08a91f0fe0ae410beb186e00401ba/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/994123/942397508f0efc846b2ca05239c317ab9e7507a7/orig',
            ids: {},
            name: 'Драйв',
            i18nKeyName: 'drive',
        },
        eats: {
            alias: 'eats',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/135516/a03749b25295017394bd4c8e225cf1042d2ae1aa/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/60661/97016dc040ed5391843ed1fd4ab6cda7c3301603/orig',
            ids: {},
            name: 'Еда',
            i18nKeyName: 'eats',
            url: 'https://eda.yandex.ru/',
        },
        taxi: {
            alias: 'taxi',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/f69214ad5be2727a27383c8b25d3ec03bf783ba7/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/994123/48f990ccafa665862e43c83ac8c965dd212d99f2/orig',
            ids: {},
            name: 'Go',
            i18nKeyName: 'taxi',
            url: 'https://go.yandex/',
        },
    },
    discounts: [
        'virtual::kinopoisk_card_discounts',
        'virtual::kinopoisk_subs_discounts',
        'virtual::new_promocode',
    ],
    servicesOrder: [
        'plus',
        'plus_360',
        'market',
        'taxi',
        'lavka',
        'eats',
        'drive',
        'refill',
        'kinopoisk',
        'afisha',
        'uslugi',
        'praktikum',
        'travel',
    ],
    plusServiceData: {
        serviceName: 'plus',
        iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/e425107fb2cf831e2043b8a0ec86ae69835c3439/svg',
        splashUrl: '//avatars.mds.yandex.net/get-bunker/56833/fc16b55a67977c0dd19bfcb626e22ce83670ca93/svg',
    },
};

export const test = {
    next: {
        created_keyset: 'e07d4eb1d225c16fa579e510efb945d3',
        order_id_keyset: 1628775287000,
    },
    orders: [
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-20T15:01:07+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '70.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '611fc3b3fbacea385e44a770',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629471676831045,
            trust_purchase_token: '0f8118ba2360f20f3350540efca8138e',
            merchant_uid: 1,
            updated: '2021-08-20T15:01:07.000+00:00',
            trust_payment_id: '611fc3b3fbacea385e44a770',
            items: [
                {
                    amount: '70.0',
                    price: '70.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-19T13:54:30+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '759.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '553691****1620',
                trust_payment_id: '611e629732da83bd8021e88c',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629456658663460,
            trust_purchase_token: '3a094fac82dc8343f6d8fb1c7edd8b9e',
            merchant_uid: 1,
            updated: '2021-08-19T13:54:30.000+00:00',
            trust_payment_id: '611e629732da83bd8021e88c',
            items: [
                {
                    amount: '193.0',
                    price: '193.0',
                    image_path: null,
                    name: 'Зубная паста LACALUT Multi-effect plus, 75 мл',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                },
                {
                    amount: '344.0',
                    price: '43.0',
                    image_path: null,
                    name: 'Пряники Рот Фронт Пряники Рот Фронт Любимые, 400 г',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                },
                {
                    amount: '222.0',
                    price: '37.0',
                    image_path: null,
                    name: 'Влажные салфетки Солнце и Луна с экстрактом алоэ вера, липучка, 63 шт.',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-18T17:31:36+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '1.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '553691****1620',
                trust_payment_id: '611d43f8f98801389b5b9ae6',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629318723348965,
            trust_purchase_token: '8a0b7f8fe2e112ec7471fc1ecd916ae5',
            merchant_uid: 1,
            updated: '2021-08-18T17:31:36.000+00:00',
            trust_payment_id: '611d43f8f98801389b5b9ae6',
            items: [
                {
                    amount: '1.0',
                    price: '1.0',
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-18T17:31:23+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '684',
            refunds: [],
            total: '8.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '553691****1620',
                trust_payment_id: '611d43eb4f5c6e1455a85b2a',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629307909017866,
            trust_purchase_token: '727e6ad0128afc8d5637109b0552a302',
            merchant_uid: 1,
            updated: '2021-08-18T17:31:23.000+00:00',
            trust_payment_id: '611d43eb4f5c6e1455a85b2a',
            items: [
                {
                    amount: '8.0',
                    price: '8.0',
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-18T17:31:23+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '731.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '611d43eb8927ca0d0d39a604',
                payment_method: 'yandex_account_withdraw',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629307891012716,
            trust_purchase_token: '44e793c902e7ab9700d2158be0579d0f',
            merchant_uid: 1,
            updated: '2021-08-18T17:31:23.000+00:00',
            trust_payment_id: '611d43eb8927ca0d0d39a604',
            items: [
                {
                    amount: '731.0',
                    price: '731.0',
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-18T08:42:42+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '69.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '611cc802f9880122995b9bc3',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629276166456154,
            trust_purchase_token: 'd18fdf4a326baab6a1a874997b0d325f',
            merchant_uid: 1,
            updated: '2021-08-18T08:42:42.000+00:00',
            trust_payment_id: '611cc802f9880122995b9bc3',
            items: [
                {
                    amount: '69.0',
                    price: '69.0',
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-18T08:42:30+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '35.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '611cc7f699d6ef1d232f7325',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629276153418761,
            trust_purchase_token: 'a78303a1d2dde98520d7170e5f5d1d57',
            merchant_uid: 1,
            updated: '2021-08-18T08:42:30.000+00:00',
            trust_payment_id: '611cc7f699d6ef1d232f7325',
            items: [
                {
                    amount: '35.0',
                    price: '35.0',
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-18T08:42:15+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '684',
            refunds: [],
            total: '6.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '553691****1620',
                trust_payment_id: '611cc7e7dbdc31dc6b6106e0',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629276153110704,
            trust_purchase_token: '4487539fa2306fd007f73291b1b32852',
            merchant_uid: 1,
            updated: '2021-08-18T08:42:15.000+00:00',
            trust_payment_id: '611cc7e7dbdc31dc6b6106e0',
            items: [
                {
                    amount: '6.0',
                    price: '6.0',
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-18T08:42:15+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '684.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '553691****1620',
                trust_payment_id: '611cc7e7bed21e3abd3e1fb7',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629286963224423,
            trust_purchase_token: '0f50d239c3ee46c044bffb806bc6948e',
            merchant_uid: 1,
            updated: '2021-08-18T08:42:15.000+00:00',
            trust_payment_id: '611cc7e7bed21e3abd3e1fb7',
            items: [
                {
                    amount: '684.0',
                    price: '684.0',
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-17T19:50:47+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '54.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '611c13175a3951ccdfc51e46',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629229850862297,
            trust_purchase_token: 'c4f9f43383d7d320f3e2c69a1a6e29cf',
            merchant_uid: 1,
            updated: '2021-08-17T19:50:47.000+00:00',
            trust_payment_id: '611c13175a3951ccdfc51e46',
            items: [
                {
                    amount: '54.0',
                    price: '54.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-17T19:30:10+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '20.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '553691****1620',
                trust_payment_id: '611c0e42954f6b3d921bc9a1',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629239428546569,
            trust_purchase_token: 'fec8db735204c5af5469101699461603',
            merchant_uid: 1,
            updated: '2021-08-17T19:30:10.000+00:00',
            trust_payment_id: '611c0e42954f6b3d921bc9a1',
            items: [
                {
                    amount: '20.0',
                    price: '20.0',
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'tip',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-17T15:04:23+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '1.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '553691****1620',
                trust_payment_id: '611bcff7c3080fa44323683e',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629223480094535,
            trust_purchase_token: '2718dc054375f9d0178dfe0610736287',
            merchant_uid: 1,
            updated: '2021-08-17T15:04:23.000+00:00',
            trust_payment_id: '611bcff7c3080fa44323683e',
            items: [
                {
                    amount: '1.0',
                    price: '1.0',
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-17T15:04:10+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '398.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '611bcfea8927ca24e139a62f',
                payment_method: 'yandex_account_withdraw',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629212656292950,
            trust_purchase_token: 'c63efed7f286da78c3659f08aeb7c40a',
            merchant_uid: 1,
            updated: '2021-08-17T15:04:10.000+00:00',
            trust_payment_id: '611bcfea8927ca24e139a62f',
            items: [
                {
                    amount: '398.0',
                    price: '398.0',
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-17T15:04:10+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '684',
            refunds: [],
            total: '1.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '553691****1620',
                trust_payment_id: '611bcfea6a8643722e507356',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629212672156754,
            trust_purchase_token: '54816fa912549feac72bb9940fb3ffbc',
            merchant_uid: 1,
            updated: '2021-08-17T15:04:10.000+00:00',
            trust_payment_id: '611bcfea6a8643722e507356',
            items: [
                {
                    amount: '1.0',
                    price: '1.0',
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-16T20:57:32+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '148.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '611ad13cbed21e023d5267a8',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629147455657627,
            trust_purchase_token: 'a6b8ba785284cecf90ebca8740d6857b',
            merchant_uid: 1,
            updated: '2021-08-16T20:57:32.000+00:00',
            trust_payment_id: '611ad13cbed21e023d5267a8',
            items: [
                {
                    amount: '148.0',
                    price: '148.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-16T01:02:43+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '792.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '555949****2740',
                trust_payment_id: '6119b933954f6b7a7de7e9ad',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629181632070717,
            trust_purchase_token: 'bdefc86563b8b73ed4d61f887f4e6019',
            merchant_uid: 1,
            updated: '2021-08-16T01:02:43.000+00:00',
            trust_payment_id: '6119b933954f6b7a7de7e9ad',
            items: [
                {
                    amount: '225.0',
                    price: '225.0',
                    image_path: null,
                    name: 'Салфетки спиртовые (этиловый спирт) UnicornMed 56x65 мм, 100 шт',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
                {
                    amount: '567.0',
                    price: '189.0',
                    image_path: null,
                    name: 'Маска медицинская 3xMask 9890 в коробке 50шт (голубая)',
                    currency: 'RUB',
                    nds: 'nds_10_110',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-14T18:51:19+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '60.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '611810a78927ca36f55e9d29',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1628967083340091,
            trust_purchase_token: '05aecca1224b22516035a78f85a28818',
            merchant_uid: 1,
            updated: '2021-08-14T18:51:19.000+00:00',
            trust_payment_id: '611810a78927ca36f55e9d29',
            items: [
                {
                    amount: '60.0',
                    price: '60.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-13T16:30:02+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '86.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '61169e0bb9f8ed363409cacb',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1628872209065136,
            trust_purchase_token: '08552445c35b9e58e36835807baccd12',
            merchant_uid: 1,
            updated: '2021-08-13T16:30:02.000+00:00',
            trust_payment_id: '61169e0bb9f8ed363409cacb',
            items: [
                {
                    amount: '86.0',
                    price: '86.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-12T17:35:04+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '40.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '61155bc803c378dfafd24fc2',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1628789707129510,
            trust_purchase_token: '65f3d604b3fc1d17509c949a8334ca7b',
            merchant_uid: 1,
            updated: '2021-08-12T17:35:04.000+00:00',
            trust_payment_id: '61155bc803c378dfafd24fc2',
            items: [
                {
                    amount: '40.0',
                    price: '40.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-12T13:34:47+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '629',
            refunds: [],
            total: '571.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '553691****1620',
                trust_payment_id: '6115237794d527238063a6ae',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1628777852650416,
            trust_purchase_token: 'e07d4eb1d225c16fa579e510efb945d3',
            merchant_uid: 1,
            updated: '2021-08-12T13:34:47.000+00:00',
            trust_payment_id: '6115237794d527238063a6ae',
            items: [
                {
                    amount: '249.0',
                    price: '249.0',
                    image_path: null,
                    name: 'Хлопья кукурузные Nestle GoFree без глютена',
                    currency: 'RUB',
                    nds: 'nds_10',
                },
                {
                    amount: '59.0',
                    price: '59.0',
                    image_path: null,
                    name: 'Трубочки для коктейля Paterra «Фантазия» с изгибом цветные',
                    currency: 'RUB',
                    nds: 'nds_20',
                },
                {
                    amount: '45.0',
                    price: '45.0',
                    image_path: null,
                    name: 'Сметана 15% «Брест-Литовск»',
                    currency: 'RUB',
                    nds: 'nds_10',
                },
                {
                    amount: '89.0',
                    price: '89.0',
                    image_path: null,
                    name: 'Картофель ранний Россия, 1 кг',
                    currency: 'RUB',
                    nds: 'nds_10',
                },
                {
                    amount: '45.0',
                    price: '45.0',
                    image_path: null,
                    name: 'Сметана 15% «Брест-Литовск»',
                    currency: 'RUB',
                    nds: 'nds_10',
                },
                {
                    amount: '55.0',
                    price: '55.0',
                    image_path: null,
                    name: 'Лук красный',
                    currency: 'RUB',
                    nds: 'nds_10',
                },
                {
                    amount: '29.0',
                    price: '29.0',
                    image_path: null,
                    name: 'Зелёный лук',
                    currency: 'RUB',
                    nds: 'nds_10',
                },
            ],
            status: 'paid',
        },
    ],
};

export const expectation = {
    edges: [
        {
            id: '1629471676831045',
            created: '2021-08-20T15:01:07+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1629471676831045',
            status: 'paid',
            total: 70,
            plus: 70,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 70,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '0f8118ba2360f20f3350540efca8138e',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629456658663460',
            created: '2021-08-19T13:54:30+00:00',
            serviceId: '610',
            refunds: [],
            items: [
                {
                    amount: '193.0',
                    price: 193,
                    image_path: null,
                    name: 'Зубная паста LACALUT Multi-effect plus, 75 мл',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                    hidden: false,
                },
                {
                    amount: '344.0',
                    price: 344,
                    image_path: null,
                    name: 'Пряники Рот Фронт Пряники Рот Фронт Любимые, 400 г',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                    hidden: false,
                },
                {
                    amount: '222.0',
                    price: 222,
                    image_path: null,
                    name: 'Влажные салфетки Солнце и Луна с экстрактом алоэ вера, липучка, 63 шт.',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                    hidden: false,
                },
            ],
            orderId: '1629456658663460',
            status: 'paid',
            total: 759,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 759,
                    account: '553691****1620',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '3a094fac82dc8343f6d8fb1c7edd8b9e',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629318723348965',
            created: '2021-08-18T17:31:36+00:00',
            serviceId: '124',
            refunds: [],
            items: [
                {
                    amount: '1.0',
                    price: 1,
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_none',
                    hidden: false,
                },
            ],
            orderId: '1629318723348965',
            status: 'paid',
            total: 1,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 1,
                    account: '553691****1620',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '8a0b7f8fe2e112ec7471fc1ecd916ae5',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629307909017866',
            created: '2021-08-18T17:31:23+00:00',
            serviceId: '684',
            refunds: [],
            items: [
                {
                    amount: '8.0',
                    price: 8,
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                    hidden: true,
                },
            ],
            orderId: '1629307909017866',
            status: 'paid',
            total: 8,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 8,
                    account: '553691****1620',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '727e6ad0128afc8d5637109b0552a302',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629307891012716',
            created: '2021-08-18T17:31:23+00:00',
            serviceId: '124',
            refunds: [],
            items: [],
            orderId: '1629307891012716',
            status: 'paid',
            total: 0,
            plus: -731,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_withdraw',
                    price: 731,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '44e793c902e7ab9700d2158be0579d0f',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629276166456154',
            created: '2021-08-18T08:42:42+00:00',
            serviceId: '124',
            refunds: [],
            items: [],
            orderId: '1629276166456154',
            status: 'paid',
            total: 69,
            plus: 69,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 69,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'd18fdf4a326baab6a1a874997b0d325f',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629276153418761',
            created: '2021-08-18T08:42:30+00:00',
            serviceId: '124',
            refunds: [],
            items: [],
            orderId: '1629276153418761',
            status: 'paid',
            total: 35,
            plus: 35,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 35,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'a78303a1d2dde98520d7170e5f5d1d57',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629276153110704',
            created: '2021-08-18T08:42:15+00:00',
            serviceId: '684',
            refunds: [],
            items: [
                {
                    amount: '6.0',
                    price: 6,
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                    hidden: true,
                },
            ],
            orderId: '1629276153110704',
            status: 'paid',
            total: 6,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 6,
                    account: '553691****1620',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '4487539fa2306fd007f73291b1b32852',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629286963224423',
            created: '2021-08-18T08:42:15+00:00',
            serviceId: '124',
            refunds: [],
            items: [
                {
                    amount: '684.0',
                    price: 684,
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_none',
                    hidden: false,
                },
            ],
            orderId: '1629286963224423',
            status: 'paid',
            total: 684,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 684,
                    account: '553691****1620',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '0f50d239c3ee46c044bffb806bc6948e',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629229850862297',
            created: '2021-08-17T19:50:47+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1629229850862297',
            status: 'paid',
            total: 54,
            plus: 54,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 54,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'c4f9f43383d7d320f3e2c69a1a6e29cf',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629239428546569',
            created: '2021-08-17T19:30:10+00:00',
            serviceId: '124',
            refunds: [],
            items: [
                {
                    amount: '20.0',
                    price: 20,
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'tip',
                    currency: 'RUB',
                    nds: 'nds_none',
                    hidden: false,
                },
            ],
            orderId: '1629239428546569',
            status: 'paid',
            total: 20,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 20,
                    account: '553691****1620',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'fec8db735204c5af5469101699461603',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629223480094535',
            created: '2021-08-17T15:04:23+00:00',
            serviceId: '124',
            refunds: [],
            items: [
                {
                    amount: '1.0',
                    price: 1,
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_none',
                    hidden: false,
                },
            ],
            orderId: '1629223480094535',
            status: 'paid',
            total: 1,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 1,
                    account: '553691****1620',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '2718dc054375f9d0178dfe0610736287',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629212656292950',
            created: '2021-08-17T15:04:10+00:00',
            serviceId: '124',
            refunds: [],
            items: [],
            orderId: '1629212656292950',
            status: 'paid',
            total: 0,
            plus: -398,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_withdraw',
                    price: 398,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'c63efed7f286da78c3659f08aeb7c40a',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629212672156754',
            created: '2021-08-17T15:04:10+00:00',
            serviceId: '684',
            refunds: [],
            items: [
                {
                    amount: '1.0',
                    price: 1,
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                    hidden: true,
                },
            ],
            orderId: '1629212672156754',
            status: 'paid',
            total: 1,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 1,
                    account: '553691****1620',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '54816fa912549feac72bb9940fb3ffbc',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629147455657627',
            created: '2021-08-16T20:57:32+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1629147455657627',
            status: 'paid',
            total: 148,
            plus: 148,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 148,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'a6b8ba785284cecf90ebca8740d6857b',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629181632070717',
            created: '2021-08-16T01:02:43+00:00',
            serviceId: '610',
            refunds: [],
            items: [
                {
                    amount: '225.0',
                    price: 225,
                    image_path: null,
                    name: 'Салфетки спиртовые (этиловый спирт) UnicornMed 56x65 мм, 100 шт',
                    currency: 'RUB',
                    nds: 'nds_none',
                    hidden: false,
                },
                {
                    amount: '567.0',
                    price: 567,
                    image_path: null,
                    name: 'Маска медицинская 3xMask 9890 в коробке 50шт (голубая)',
                    currency: 'RUB',
                    nds: 'nds_10_110',
                    hidden: false,
                },
            ],
            orderId: '1629181632070717',
            status: 'paid',
            total: 792,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 792,
                    account: '555949****2740',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'bdefc86563b8b73ed4d61f887f4e6019',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1628967083340091',
            created: '2021-08-14T18:51:19+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1628967083340091',
            status: 'paid',
            total: 60,
            plus: 60,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 60,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '05aecca1224b22516035a78f85a28818',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1628872209065136',
            created: '2021-08-13T16:30:02+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1628872209065136',
            status: 'paid',
            total: 86,
            plus: 86,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 86,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '08552445c35b9e58e36835807baccd12',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1628789707129510',
            created: '2021-08-12T17:35:04+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1628789707129510',
            status: 'paid',
            total: 40,
            plus: 40,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 40,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '65f3d604b3fc1d17509c949a8334ca7b',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1628777852650416',
            created: '2021-08-12T13:34:47+00:00',
            serviceId: '629',
            refunds: [],
            items: [
                {
                    amount: '249.0',
                    price: 249,
                    image_path: null,
                    name: 'Хлопья кукурузные Nestle GoFree без глютена',
                    currency: 'RUB',
                    nds: 'nds_10',
                    hidden: false,
                },
                {
                    amount: '59.0',
                    price: 59,
                    image_path: null,
                    name: 'Трубочки для коктейля Paterra «Фантазия» с изгибом цветные',
                    currency: 'RUB',
                    nds: 'nds_20',
                    hidden: false,
                },
                {
                    amount: '45.0',
                    price: 45,
                    image_path: null,
                    name: 'Сметана 15% «Брест-Литовск»',
                    currency: 'RUB',
                    nds: 'nds_10',
                    hidden: false,
                },
                {
                    amount: '89.0',
                    price: 89,
                    image_path: null,
                    name: 'Картофель ранний Россия, 1 кг',
                    currency: 'RUB',
                    nds: 'nds_10',
                    hidden: false,
                },
                {
                    amount: '45.0',
                    price: 45,
                    image_path: null,
                    name: 'Сметана 15% «Брест-Литовск»',
                    currency: 'RUB',
                    nds: 'nds_10',
                    hidden: false,
                },
                {
                    amount: '55.0',
                    price: 55,
                    image_path: null,
                    name: 'Лук красный',
                    currency: 'RUB',
                    nds: 'nds_10',
                    hidden: false,
                },
                {
                    amount: '29.0',
                    price: 29,
                    image_path: null,
                    name: 'Зелёный лук',
                    currency: 'RUB',
                    nds: 'nds_10',
                    hidden: false,
                },
            ],
            orderId: '1628777852650416',
            status: 'paid',
            total: 571,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 571,
                    account: '553691****1620',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'e07d4eb1d225c16fa579e510efb945d3',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
    ],
    pageInfo: {
        hasNextPage: true,
        startCursor: null,
        hasPreviousPage: false,
        endCursor: 'MTYyODc3NTI4NzAwMF9fZTA3ZDRlYjFkMjI1YzE2ZmE1NzllNTEwZWZiOTQ1ZDM=',
    },
};
