export const context = {
    services: {
        refill: {
            alias: 'refill',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/998550/3b095c224131ca8faa87bfec5099a480c1fda911/svg',
            ids: {},
            name: 'Заправки',
            i18nKeyName: 'refill',
            url: 'https://zapravki.yandex.ru/',
            help: 'https://yandex.ru/chat#/user/3d8f0007-f610-914e-45f7-3eddaf3cc441',
        },
        plus_360: {
            alias: 'plus_360',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/994123/49ef2ec62be2f58b5f765b12cdfd9a04dd826e0e/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/994123/e4a8e3d3f8810a4cbebed1fc7f8952bd5df8d870/orig',
            ids: {},
            name: 'Подписка Яндекс 360',
            i18nKeyName: 'plus_360',
            url: 'https://mail360.yandex.ru',
            help: 'https://yandex.ru/support/mail/yandex-360.html',
        },
        praktikum: {
            alias: 'praktikum',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/994123/2029eb942ed84255579609bdd006f29bd6710d75/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/118781/57dd72c90f5871728407efd8c1e14495fee46761/orig',
            ids: {},
            name: 'Практикум',
            i18nKeyName: 'praktikum',
            url: 'https://practicum.yandex.ru/',
            help: 'https://yandex.ru/support/praktikum/feedback.html',
        },
        travel: {
            alias: 'travel',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/61205/e18dfaf6ae7e62e4a3be97bfd77e57ef33541404/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/994123/e1b838d55b6d1640a31323774f4f5a77a349766e/orig',
            ids: {},
            name: 'Путешествия',
            i18nKeyName: 'travel',
            url: 'https://travel.yandex.ru/hotels/',
            help: 'https://yandex.ru/support/travel/troubleshooting.html',
        },
        market: {
            alias: 'market',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/998550/ae1b6a5e3bd6905ee694fedc593e6ac497fee0e2/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/56833/35e70a852d59a7bd9c229bbf7d943f9155e65948/orig',
            ids: {},
            name: 'Маркет',
            i18nKeyName: 'market',
            url: 'https://pokupki.market.yandex.ru/my/orders',
        },
        afisha: {
            alias: 'afisha',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/128809/d4f71a94e2abd037b9e3862eca8824f6188ce7a9/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/60661/ea8ff7736616b4920852a9d4fc937fb2bbf8b8b8/orig',
            ids: {},
            name: 'Афиша',
            i18nKeyName: 'afisha',
            url: 'https://afisha.yandex.ru/',
        },
        kinopoisk: {
            alias: 'kinopoisk',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/49769/3c8752854e2d9fb4145b9a995cab8017321d774d/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/49769/e4070af0aefcd6fe2170ff14dbe5e58bad3e97d1/orig',
            ids: {},
            name: 'КиноПоиск',
            i18nKeyName: 'kinopoisk',
            url: 'https://hd.kinopoisk.ru/purchases',
        },
        plus: {
            alias: 'plus',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/e425107fb2cf831e2043b8a0ec86ae69835c3439/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/56833/fc16b55a67977c0dd19bfcb626e22ce83670ca93/svg',
            ids: {},
            name: 'Плюс',
            i18nKeyName: 'plus',
        },
        help_nko: {
            alias: 'help_nko',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/49769/b151a0f4a3796df437ebb45d913a4078289a8a7b/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/128809/6bf5ba7f303e3a6285667d61378b3133d1321a62/orig',
            ids: {},
            name: 'Помощь рядом',
            i18nKeyName: 'help_nearby',
            url: 'https://help.yandex.ru/roundup',
        },
        pay: {
            alias: 'pay',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/e425107fb2cf831e2043b8a0ec86ae69835c3439/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/56833/fc16b55a67977c0dd19bfcb626e22ce83670ca93/svg',
            ids: {},
            name: 'Pay',
            i18nKeyName: 'pay',
        },
        uslugi: {
            alias: 'uslugi',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/9da97fa2062af980929974de64343d47f49f72e8/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/998550/15a34c77fe975dabfe58f39f4e882d5ecc103d9e/orig',
            ids: {},
            name: 'Услуги',
            i18nKeyName: 'uslugi',
            url: 'https://uslugi.yandex.ru/my-orders',
            help: 'https://yandex.ru/chat#/user/3ea8c303-761b-9ce6-7a27-1a6cafa572f2',
        },
        lavka: {
            alias: 'lavka',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/49769/ae04ac827389ecf6786984250872830981ca4659/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/50064/908b53b0849408ce580da95a801c9a9ee130e255/orig',
            ids: {},
            name: 'Лавка',
            i18nKeyName: 'lavka',
            url: 'https://lavka.yandex.ru',
        },
        drive: {
            alias: 'drive',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/49769/622ce19ef4e08a91f0fe0ae410beb186e00401ba/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/994123/942397508f0efc846b2ca05239c317ab9e7507a7/orig',
            ids: {},
            name: 'Драйв',
            i18nKeyName: 'drive',
        },
        eats: {
            alias: 'eats',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/135516/a03749b25295017394bd4c8e225cf1042d2ae1aa/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/60661/97016dc040ed5391843ed1fd4ab6cda7c3301603/orig',
            ids: {},
            name: 'Еда',
            i18nKeyName: 'eats',
            url: 'https://eda.yandex.ru/',
        },
        taxi: {
            alias: 'taxi',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/f69214ad5be2727a27383c8b25d3ec03bf783ba7/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/994123/48f990ccafa665862e43c83ac8c965dd212d99f2/orig',
            ids: {},
            name: 'Go',
            i18nKeyName: 'taxi',
            url: 'https://go.yandex/',
        },
    },
    discounts: [
        'virtual::kinopoisk_card_discounts',
        'virtual::kinopoisk_subs_discounts',
        'virtual::new_promocode',
    ],
    servicesOrder: [
        'plus',
        'plus_360',
        'market',
        'taxi',
        'lavka',
        'eats',
        'drive',
        'refill',
        'kinopoisk',
        'afisha',
        'uslugi',
        'praktikum',
        'travel',
    ],
    plusServiceData: {
        serviceName: 'plus',
        iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/e425107fb2cf831e2043b8a0ec86ae69835c3439/svg',
        splashUrl: '//avatars.mds.yandex.net/get-bunker/56833/fc16b55a67977c0dd19bfcb626e22ce83670ca93/svg',
    },
};

export const test = {
    next: {
        created_keyset: '5eed0a87820e0b8f32da898deb279d85',
        order_id_keyset: 1626446528000,
    },
    orders: [
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-11T01:41:41+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '1020.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '555949****2740',
                trust_payment_id: '61132ad54f5c6e45669766a2',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1628751314524897,
            trust_purchase_token: 'c6f5945672a5912ff6a342950e7c5def',
            merchant_uid: 1,
            updated: '2021-08-11T01:41:41.000+00:00',
            trust_payment_id: '61132ad54f5c6e45669766a2',
            items: [
                {
                    amount: '378.0',
                    price: '189.0',
                    image_path: null,
                    name: 'Маска медицинская 3xMask 9890 в коробке 50шт (голубая)',
                    currency: 'RUB',
                    nds: 'nds_10_110',
                },
                {
                    amount: '218.0',
                    price: '109.0',
                    image_path: null,
                    name: 'Олейна масло подсолнечное Классическое, 1 л',
                    currency: 'RUB',
                    nds: 'nds_10_110',
                },
                {
                    amount: '300.0',
                    price: '75.0',
                    image_path: null,
                    name: 'Жидкое мыло Невская Косметика Дегтярное для рук и тела, 300 мл',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                },
                {
                    amount: '124.0',
                    price: '31.0',
                    image_path: null,
                    name: 'Пряники Рот Фронт Пряники Рот Фронт Любимые, 400 г',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-01T14:03:41+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '16.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '6106a9bddff13b71b67f0560',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1627826623945160,
            trust_purchase_token: '8e09b0dea3b5c867c255959c6b2b8f4f',
            merchant_uid: 1,
            updated: '2021-08-01T14:03:41.000+00:00',
            trust_payment_id: '6106a9bddff13b71b67f0560',
            items: [
                {
                    amount: '16.0',
                    price: '16.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-01T14:03:27+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '177.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '6106a9b003c37894964685cb',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1627826611490244,
            trust_purchase_token: '7bfc5d81e303afa940fc6c1724bcafdd',
            merchant_uid: 1,
            updated: '2021-08-01T14:03:27.000+00:00',
            trust_payment_id: '6106a9b003c37894964685cb',
            items: [
                {
                    amount: '177.0',
                    price: '177.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-01T13:37:17+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '629',
            refunds: [],
            total: '90.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '553691****1620',
                trust_payment_id: '6106a38d32da8341957deca8',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1627826487352223,
            trust_purchase_token: 'a23502f2938bb2a4e74177067bd493d4',
            merchant_uid: 1,
            updated: '2021-08-01T13:37:17.000+00:00',
            trust_payment_id: '6106a38d32da8341957deca8',
            items: [
                {
                    amount: '45.0',
                    price: '45.0',
                    image_path: null,
                    name: 'Сметана 15% «Брест-Литовск»',
                    currency: 'RUB',
                    nds: 'nds_10',
                },
                {
                    amount: '45.0',
                    price: '45.0',
                    image_path: null,
                    name: 'Сметана 15% «Брест-Литовск»',
                    currency: 'RUB',
                    nds: 'nds_10',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-30T17:20:10+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '1931.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '555949****2740',
                trust_payment_id: '610434cafbacea6381f91424',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1627794199387559,
            trust_purchase_token: '47464ccff28f7e1737095514ce9930c8',
            merchant_uid: 1,
            updated: '2021-07-30T17:20:10.000+00:00',
            trust_payment_id: '610434cafbacea6381f91424',
            items: [
                {
                    amount: '1767.0',
                    price: '1767.0',
                    image_path: null,
                    name: 'Wi-Fi роутер Xiaomi Mi Wi-Fi Router 4, белый',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                },
                {
                    amount: '164.0',
                    price: '41.0',
                    image_path: null,
                    name: 'Пряники Рот Фронт Пряники Рот Фронт Любимые, 400 г',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-29T15:48:50+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '629',
            refunds: [],
            total: '30.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '6102cde304e94315f23820e8',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1627573734583869,
            trust_purchase_token: 'de3a197fc25cabb413d3a980747ea7f4',
            merchant_uid: 1,
            updated: '2021-07-29T15:48:50.000+00:00',
            trust_payment_id: '6102cde304e94315f23820e8',
            items: [
                {
                    amount: '30.0',
                    price: '30.0',
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-29T15:23:15+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '629',
            refunds: [
                {
                    total: '45.0',
                    refund_status: 'completed',
                    currency: 'RUB',
                    trust_refund_id: '6102cdda4f5c6e5c20303aa0',
                    items: [
                        {
                            amount: '45.0',
                            price: '45.0',
                            name: 'Сметана 15% «Брест-Литовск»',
                            currency: 'RUB',
                            nds: 'nds_10',
                        },
                    ],
                },
            ],
            total: '1055.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '553691****1620',
                trust_payment_id: '6102c7e3dbdc31e5d4dcf981',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1627573724386438,
            trust_purchase_token: '3dd5bcdc123b7ba01469220ff80c5ce3',
            merchant_uid: 1,
            updated: '2021-07-29T15:23:15.000+00:00',
            trust_payment_id: '6102c7e3dbdc31e5d4dcf981',
            items: [
                {
                    amount: '89.0',
                    price: '89.0',
                    image_path: null,
                    name: 'Рулет ром-изюм «буше»',
                    currency: 'RUB',
                    nds: 'nds_10',
                },
                {
                    amount: '105.0',
                    price: '105.0',
                    image_path: null,
                    name: 'Турнель с сыром и ветчиной «буше»',
                    currency: 'RUB',
                    nds: 'nds_10',
                },
                {
                    amount: '129.0',
                    price: '129.0',
                    image_path: null,
                    name: 'Слойка  баварская орех «буше»',
                    currency: 'RUB',
                    nds: 'nds_10',
                },
                {
                    amount: '95.0',
                    price: '95.0',
                    image_path: null,
                    name: 'Круассан сыр «буше»',
                    currency: 'RUB',
                    nds: 'nds_10',
                },
                {
                    amount: '99.0',
                    price: '99.0',
                    image_path: null,
                    name: 'Попкорн «Из Лавки» сладко-солёный',
                    currency: 'RUB',
                    nds: 'nds_20',
                },
                {
                    amount: '49.0',
                    price: '49.0',
                    image_path: null,
                    name: 'Чипсы кукурузно-рисовые Dr. Korner Корнерсы сыр начо',
                    currency: 'RUB',
                    nds: 'nds_10',
                },
                {
                    amount: '250.0',
                    price: '250.0',
                    image_path: null,
                    name: 'Баркетта  карамель-орех «буше»',
                    currency: 'RUB',
                    nds: 'nds_20',
                },
                {
                    amount: '135.0',
                    price: '135.0',
                    image_path: null,
                    name: 'Чипсы с нори «Пакет картошки»',
                    currency: 'RUB',
                    nds: 'nds_20',
                },
                {
                    amount: '49.0',
                    price: '49.0',
                    image_path: null,
                    name: 'Чипсы кукурузно-рисовые Dr. Korner Корнерсы томат-базилик',
                    currency: 'RUB',
                    nds: 'nds_10',
                },
                {
                    amount: '45.0',
                    price: '45.0',
                    image_path: null,
                    name: 'Сметана 15% «Брест-Литовск»',
                    currency: 'RUB',
                    nds: 'nds_10',
                },
                {
                    amount: '55.0',
                    price: '55.0',
                    image_path: null,
                    name: 'Сметана 20% «Брест-Литовск»',
                    currency: 'RUB',
                    nds: 'nds_10',
                },
            ],
            status: 'refunded',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-26T15:56:23+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '40.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60fedb289066f416e4a386e6',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1627314986199429,
            trust_purchase_token: '1d0a41b2e296efc581a7e60a83f26c82',
            merchant_uid: 1,
            updated: '2021-07-26T15:56:23.000+00:00',
            trust_payment_id: '60fedb289066f416e4a386e6',
            items: [
                {
                    amount: '40.0',
                    price: '40.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-26T13:23:05+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '182.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60feb73a03c37824ce0b738b',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1627305789005492,
            trust_purchase_token: '13464e0a929c3089110e1a12ab949ea8',
            merchant_uid: 1,
            updated: '2021-07-26T13:23:05.000+00:00',
            trust_payment_id: '60feb73a03c37824ce0b738b',
            items: [
                {
                    amount: '182.0',
                    price: '182.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-26T12:28:35+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '16.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60feaa73f78dba50cf7ec6de',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1627302519207222,
            trust_purchase_token: '5289e243b2e7459353ca3317783a2d4f',
            merchant_uid: 1,
            updated: '2021-07-26T12:28:35.000+00:00',
            trust_payment_id: '60feaa73f78dba50cf7ec6de',
            items: [
                {
                    amount: '16.0',
                    price: '16.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-24T22:15:42+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '684',
            refunds: [],
            total: '1.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '555949****2740',
                trust_payment_id: '60fc910e8927ca0f8aa8b182',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1627164970023929,
            trust_purchase_token: '466179d2e285712b57784c1ffd8ef107',
            merchant_uid: 1,
            updated: '2021-07-24T22:15:42.000+00:00',
            trust_payment_id: '60fc910e8927ca0f8aa8b182',
            items: [
                {
                    amount: '1.0',
                    price: '1.0',
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-24T22:15:22+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '1809.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '555949****2740',
                trust_payment_id: '60fc90fa9066f44b5c74b92f',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1627283918034476,
            trust_purchase_token: 'af7501b5133c9aefb663039dacc6dfcd',
            merchant_uid: 1,
            updated: '2021-07-24T22:15:22.000+00:00',
            trust_payment_id: '60fc90fa9066f44b5c74b92f',
            items: [
                {
                    amount: '954.0',
                    price: '318.0',
                    image_path: null,
                    name: 'Кофе Nescafe Classic растворимый с добавлением молотой арабики, пакет, 500 г',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                },
                {
                    amount: '855.0',
                    price: '855.0',
                    image_path: null,
                    name: 'Сменные кассеты Gillette Fusion5, 4 шт.',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-24T21:47:55+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '656.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '555949****2740',
                trust_payment_id: '60fc8a8b94d52708f6c25c2b',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1627273362283977,
            trust_purchase_token: '39593697e3c134bcb6397191f0ee3fb6',
            merchant_uid: 1,
            updated: '2021-07-24T21:47:55.000+00:00',
            trust_payment_id: '60fc8a8b94d52708f6c25c2b',
            items: [
                {
                    amount: '240.0',
                    price: '30.0',
                    image_path: null,
                    name: 'Пряники Рот Фронт Пряники Рот Фронт Любимые, 400 г',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                },
                {
                    amount: '198.0',
                    price: '99.0',
                    image_path: null,
                    name: 'Гречневая крупа Мистраль ядрица, 900 г',
                    currency: 'RUB',
                    nds: 'nds_10_110',
                },
                {
                    amount: '218.0',
                    price: '109.0',
                    image_path: null,
                    name: 'Олейна масло подсолнечное Классическое, 1 л',
                    currency: 'RUB',
                    nds: 'nds_10_110',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-24T12:34:07+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '29.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60fc08c07399013ad11c51f6',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1627130047678967,
            trust_purchase_token: 'e2ca9cdf92dbda3a03dc829ac27155d5',
            merchant_uid: 1,
            updated: '2021-07-24T12:34:07.000+00:00',
            trust_payment_id: '60fc08c07399013ad11c51f6',
            items: [
                {
                    amount: '29.0',
                    price: '29.0',
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-21T17:23:56+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '18.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60f8582d03c37806e5866e59',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1626888236946141,
            trust_purchase_token: '480a82c053719b546213429accd8a93d',
            merchant_uid: 1,
            updated: '2021-07-21T17:23:56.000+00:00',
            trust_payment_id: '60f8582d03c37806e5866e59',
            items: [
                {
                    amount: '18.0',
                    price: '18.0',
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-21T17:23:22+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '37.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60f8580a2fe0983f8cb99c1b',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1626888202575372,
            trust_purchase_token: 'd71357ed4319205b3036e8895b8f0d01',
            merchant_uid: 1,
            updated: '2021-07-21T17:23:22.000+00:00',
            trust_payment_id: '60f8580a2fe0983f8cb99c1b',
            items: [
                {
                    amount: '37.0',
                    price: '37.0',
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-21T17:04:16+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '629',
            refunds: [],
            total: '144.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '553691****1620',
                trust_payment_id: '60f853909066f4427d4ec029',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1626887056721448,
            trust_purchase_token: '63b8f075e3e4fc2024b34e8b7f5a8aad',
            merchant_uid: 1,
            updated: '2021-07-21T17:04:16.000+00:00',
            trust_payment_id: '60f853909066f4427d4ec029',
            items: [
                {
                    amount: '29.0',
                    price: '29.0',
                    image_path: null,
                    name: 'Батон «Пшеничный» «Каравай» нарезка',
                    currency: 'RUB',
                    nds: 'nds_10',
                },
                {
                    amount: '29.0',
                    price: '29.0',
                    image_path: null,
                    name: 'Батон «Пшеничный» «Каравай» нарезка',
                    currency: 'RUB',
                    nds: 'nds_10',
                },
                {
                    amount: '43.0',
                    price: '43.0',
                    image_path: null,
                    name: 'Батон «Домашний» «Хлебный дом»',
                    currency: 'RUB',
                    nds: 'nds_10',
                },
                {
                    amount: '43.0',
                    price: '43.0',
                    image_path: null,
                    name: 'Батон «Домашний» «Хлебный дом»',
                    currency: 'RUB',
                    nds: 'nds_10',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-18T21:32:49+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '831.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '555949****2740',
                trust_payment_id: '60f49e0104e94371a6d9b66f',
                payment_method: 'card',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1626643969470004,
            trust_purchase_token: '68d7975a034195f6640a0e0a3cb9ab6b',
            merchant_uid: 1,
            updated: '2021-07-18T21:32:49.000+00:00',
            trust_payment_id: '60f49e0104e94371a6d9b66f',
            items: [
                {
                    amount: '369.0',
                    price: '369.0',
                    image_path: null,
                    name: 'Камера для велосипеда VeloSmile 28х1,25/1,6 (32/40-622) AV, Россия',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
                {
                    amount: '287.0',
                    price: '287.0',
                    image_path: null,
                    name: 'Велокамера 28*1.50/1.75 под автовентиль "Duro"',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
                {
                    amount: '175.0',
                    price: '175.0',
                    image_path: null,
                    name: 'Sanfor спрей-пена Акрилайт, 0.7 л',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-16T14:51:17+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '61.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60f19ce583b1f208c67d4416',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1626447077251000,
            trust_purchase_token: 'f905a1c4f359a65232271b0ec9643089',
            merchant_uid: 1,
            updated: '2021-07-16T14:51:17.000+00:00',
            trust_payment_id: '60f19ce583b1f208c67d4416',
            items: [
                {
                    amount: '61.0',
                    price: '61.0',
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-16T14:42:08+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '18.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60f19ac02fe09829169a82c1',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1626446528893473,
            trust_purchase_token: '5eed0a87820e0b8f32da898deb279d85',
            merchant_uid: 1,
            updated: '2021-07-16T14:42:08.000+00:00',
            trust_payment_id: '60f19ac02fe09829169a82c1',
            items: [
                {
                    amount: '18.0',
                    price: '18.0',
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
    ],
};

export const expectation = {
    edges: [
        {
            id: '1628751314524897',
            created: '2021-08-11T01:41:41+00:00',
            serviceId: '610',
            refunds: [],
            items: [
                {
                    amount: '378.0',
                    price: 378,
                    image_path: null,
                    name: 'Маска медицинская 3xMask 9890 в коробке 50шт (голубая)',
                    currency: 'RUB',
                    nds: 'nds_10_110',
                    hidden: false,
                },
                {
                    amount: '218.0',
                    price: 218,
                    image_path: null,
                    name: 'Олейна масло подсолнечное Классическое, 1 л',
                    currency: 'RUB',
                    nds: 'nds_10_110',
                    hidden: false,
                },
                {
                    amount: '300.0',
                    price: 300,
                    image_path: null,
                    name: 'Жидкое мыло Невская Косметика Дегтярное для рук и тела, 300 мл',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                    hidden: false,
                },
                {
                    amount: '124.0',
                    price: 124,
                    image_path: null,
                    name: 'Пряники Рот Фронт Пряники Рот Фронт Любимые, 400 г',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                    hidden: false,
                },
            ],
            orderId: '1628751314524897',
            status: 'paid',
            total: 1020,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 1020,
                    account: '555949****2740',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'c6f5945672a5912ff6a342950e7c5def',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1627826623945160',
            created: '2021-08-01T14:03:41+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1627826623945160',
            status: 'paid',
            total: 16,
            plus: 16,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 16,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '8e09b0dea3b5c867c255959c6b2b8f4f',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1627826611490244',
            created: '2021-08-01T14:03:27+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1627826611490244',
            status: 'paid',
            total: 177,
            plus: 177,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 177,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '7bfc5d81e303afa940fc6c1724bcafdd',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1627826487352223',
            created: '2021-08-01T13:37:17+00:00',
            serviceId: '629',
            refunds: [],
            items: [
                {
                    amount: '45.0',
                    price: 45,
                    image_path: null,
                    name: 'Сметана 15% «Брест-Литовск»',
                    currency: 'RUB',
                    nds: 'nds_10',
                    hidden: false,
                },
                {
                    amount: '45.0',
                    price: 45,
                    image_path: null,
                    name: 'Сметана 15% «Брест-Литовск»',
                    currency: 'RUB',
                    nds: 'nds_10',
                    hidden: false,
                },
            ],
            orderId: '1627826487352223',
            status: 'paid',
            total: 90,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 90,
                    account: '553691****1620',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'a23502f2938bb2a4e74177067bd493d4',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1627794199387559',
            created: '2021-07-30T17:20:10+00:00',
            serviceId: '610',
            refunds: [],
            items: [
                {
                    amount: '1767.0',
                    price: 1767,
                    image_path: null,
                    name: 'Wi-Fi роутер Xiaomi Mi Wi-Fi Router 4, белый',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                    hidden: false,
                },
                {
                    amount: '164.0',
                    price: 164,
                    image_path: null,
                    name: 'Пряники Рот Фронт Пряники Рот Фронт Любимые, 400 г',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                    hidden: false,
                },
            ],
            orderId: '1627794199387559',
            status: 'paid',
            total: 1931,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 1931,
                    account: '555949****2740',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '47464ccff28f7e1737095514ce9930c8',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1627573734583869',
            created: '2021-07-29T15:48:50+00:00',
            serviceId: '629',
            refunds: [],
            items: [],
            orderId: '1627573734583869',
            status: 'paid',
            total: 30,
            plus: 30,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 30,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'de3a197fc25cabb413d3a980747ea7f4',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1627573724386438_refund_0',
            created: '2021-07-29T15:23:15+00:00',
            serviceId: '629',
            refunds: [
                {
                    paymentMethod: 'card',
                    total: 45,
                    items: [
                        {
                            amount: '45.0',
                            price: 45,
                            name: 'Сметана 15% «Брест-Литовск»',
                            currency: 'RUB',
                            nds: 'nds_10',
                            hidden: false,
                        },
                    ],
                    currency: 'RUB',
                    account: '553691****1620',
                },
            ],
            items: [],
            orderId: '1627573724386438_refund_0',
            status: 'refunded',
            total: 45,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    price: 45,
                    currency: 'RUB',
                    method: 'card',
                    account: '553691****1620',
                },
            ],
            refundOnly: false,
            purchaseToken: '3dd5bcdc123b7ba01469220ff80c5ce3',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
            fake: true,
        },
        {
            id: '1627573724386438',
            created: '2021-07-29T15:23:15+00:00',
            serviceId: '629',
            refunds: [],
            items: [
                {
                    amount: '89.0',
                    price: 89,
                    image_path: null,
                    name: 'Рулет ром-изюм «буше»',
                    currency: 'RUB',
                    nds: 'nds_10',
                    hidden: false,
                },
                {
                    amount: '105.0',
                    price: 105,
                    image_path: null,
                    name: 'Турнель с сыром и ветчиной «буше»',
                    currency: 'RUB',
                    nds: 'nds_10',
                    hidden: false,
                },
                {
                    amount: '129.0',
                    price: 129,
                    image_path: null,
                    name: 'Слойка  баварская орех «буше»',
                    currency: 'RUB',
                    nds: 'nds_10',
                    hidden: false,
                },
                {
                    amount: '95.0',
                    price: 95,
                    image_path: null,
                    name: 'Круассан сыр «буше»',
                    currency: 'RUB',
                    nds: 'nds_10',
                    hidden: false,
                },
                {
                    amount: '99.0',
                    price: 99,
                    image_path: null,
                    name: 'Попкорн «Из Лавки» сладко-солёный',
                    currency: 'RUB',
                    nds: 'nds_20',
                    hidden: false,
                },
                {
                    amount: '49.0',
                    price: 49,
                    image_path: null,
                    name: 'Чипсы кукурузно-рисовые Dr. Korner Корнерсы сыр начо',
                    currency: 'RUB',
                    nds: 'nds_10',
                    hidden: false,
                },
                {
                    amount: '250.0',
                    price: 250,
                    image_path: null,
                    name: 'Баркетта  карамель-орех «буше»',
                    currency: 'RUB',
                    nds: 'nds_20',
                    hidden: false,
                },
                {
                    amount: '135.0',
                    price: 135,
                    image_path: null,
                    name: 'Чипсы с нори «Пакет картошки»',
                    currency: 'RUB',
                    nds: 'nds_20',
                    hidden: false,
                },
                {
                    amount: '49.0',
                    price: 49,
                    image_path: null,
                    name: 'Чипсы кукурузно-рисовые Dr. Korner Корнерсы томат-базилик',
                    currency: 'RUB',
                    nds: 'nds_10',
                    hidden: false,
                },
                {
                    amount: '45.0',
                    price: 45,
                    image_path: null,
                    name: 'Сметана 15% «Брест-Литовск»',
                    currency: 'RUB',
                    nds: 'nds_10',
                    hidden: false,
                },
                {
                    amount: '55.0',
                    price: 55,
                    image_path: null,
                    name: 'Сметана 20% «Брест-Литовск»',
                    currency: 'RUB',
                    nds: 'nds_10',
                    hidden: false,
                },
            ],
            orderId: '1627573724386438',
            status: 'paid',
            total: 1055,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 1055,
                    account: '553691****1620',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '3dd5bcdc123b7ba01469220ff80c5ce3',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1627314986199429',
            created: '2021-07-26T15:56:23+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1627314986199429',
            status: 'paid',
            total: 40,
            plus: 40,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 40,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '1d0a41b2e296efc581a7e60a83f26c82',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1627305789005492',
            created: '2021-07-26T13:23:05+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1627305789005492',
            status: 'paid',
            total: 182,
            plus: 182,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 182,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '13464e0a929c3089110e1a12ab949ea8',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1627302519207222',
            created: '2021-07-26T12:28:35+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1627302519207222',
            status: 'paid',
            total: 16,
            plus: 16,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 16,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '5289e243b2e7459353ca3317783a2d4f',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1627164970023929',
            created: '2021-07-24T22:15:42+00:00',
            serviceId: '684',
            refunds: [],
            items: [
                {
                    amount: '1.0',
                    price: 1,
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                    hidden: true,
                },
            ],
            orderId: '1627164970023929',
            status: 'paid',
            total: 1,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 1,
                    account: '555949****2740',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '466179d2e285712b57784c1ffd8ef107',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1627283918034476',
            created: '2021-07-24T22:15:22+00:00',
            serviceId: '610',
            refunds: [],
            items: [
                {
                    amount: '954.0',
                    price: 954,
                    image_path: null,
                    name: 'Кофе Nescafe Classic растворимый с добавлением молотой арабики, пакет, 500 г',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                    hidden: false,
                },
                {
                    amount: '855.0',
                    price: 855,
                    image_path: null,
                    name: 'Сменные кассеты Gillette Fusion5, 4 шт.',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                    hidden: false,
                },
            ],
            orderId: '1627283918034476',
            status: 'paid',
            total: 1809,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 1809,
                    account: '555949****2740',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'af7501b5133c9aefb663039dacc6dfcd',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1627273362283977',
            created: '2021-07-24T21:47:55+00:00',
            serviceId: '610',
            refunds: [],
            items: [
                {
                    amount: '240.0',
                    price: 240,
                    image_path: null,
                    name: 'Пряники Рот Фронт Пряники Рот Фронт Любимые, 400 г',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                    hidden: false,
                },
                {
                    amount: '198.0',
                    price: 198,
                    image_path: null,
                    name: 'Гречневая крупа Мистраль ядрица, 900 г',
                    currency: 'RUB',
                    nds: 'nds_10_110',
                    hidden: false,
                },
                {
                    amount: '218.0',
                    price: 218,
                    image_path: null,
                    name: 'Олейна масло подсолнечное Классическое, 1 л',
                    currency: 'RUB',
                    nds: 'nds_10_110',
                    hidden: false,
                },
            ],
            orderId: '1627273362283977',
            status: 'paid',
            total: 656,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 656,
                    account: '555949****2740',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '39593697e3c134bcb6397191f0ee3fb6',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1627130047678967',
            created: '2021-07-24T12:34:07+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1627130047678967',
            status: 'paid',
            total: 29,
            plus: 29,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 29,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'e2ca9cdf92dbda3a03dc829ac27155d5',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1626888236946141',
            created: '2021-07-21T17:23:56+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1626888236946141',
            status: 'paid',
            total: 18,
            plus: 18,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 18,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '480a82c053719b546213429accd8a93d',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1626888202575372',
            created: '2021-07-21T17:23:22+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1626888202575372',
            status: 'paid',
            total: 37,
            plus: 37,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 37,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'd71357ed4319205b3036e8895b8f0d01',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1626887056721448',
            created: '2021-07-21T17:04:16+00:00',
            serviceId: '629',
            refunds: [],
            items: [
                {
                    amount: '29.0',
                    price: 29,
                    image_path: null,
                    name: 'Батон «Пшеничный» «Каравай» нарезка',
                    currency: 'RUB',
                    nds: 'nds_10',
                    hidden: false,
                },
                {
                    amount: '29.0',
                    price: 29,
                    image_path: null,
                    name: 'Батон «Пшеничный» «Каравай» нарезка',
                    currency: 'RUB',
                    nds: 'nds_10',
                    hidden: false,
                },
                {
                    amount: '43.0',
                    price: 43,
                    image_path: null,
                    name: 'Батон «Домашний» «Хлебный дом»',
                    currency: 'RUB',
                    nds: 'nds_10',
                    hidden: false,
                },
                {
                    amount: '43.0',
                    price: 43,
                    image_path: null,
                    name: 'Батон «Домашний» «Хлебный дом»',
                    currency: 'RUB',
                    nds: 'nds_10',
                    hidden: false,
                },
            ],
            orderId: '1626887056721448',
            status: 'paid',
            total: 144,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 144,
                    account: '553691****1620',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '63b8f075e3e4fc2024b34e8b7f5a8aad',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1626643969470004',
            created: '2021-07-18T21:32:49+00:00',
            serviceId: '610',
            refunds: [],
            items: [
                {
                    amount: '369.0',
                    price: 369,
                    image_path: null,
                    name: 'Камера для велосипеда VeloSmile 28х1,25/1,6 (32/40-622) AV, Россия',
                    currency: 'RUB',
                    nds: 'nds_none',
                    hidden: false,
                },
                {
                    amount: '287.0',
                    price: 287,
                    image_path: null,
                    name: 'Велокамера 28*1.50/1.75 под автовентиль "Duro"',
                    currency: 'RUB',
                    nds: 'nds_none',
                    hidden: false,
                },
                {
                    amount: '175.0',
                    price: 175,
                    image_path: null,
                    name: 'Sanfor спрей-пена Акрилайт, 0.7 л',
                    currency: 'RUB',
                    nds: 'nds_20_120',
                    hidden: false,
                },
            ],
            orderId: '1626643969470004',
            status: 'paid',
            total: 831,
            plus: 0,
            currency: 'RUB',
            payments: [
                {
                    method: 'card',
                    price: 831,
                    account: '555949****2740',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '68d7975a034195f6640a0e0a3cb9ab6b',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1626447077251000',
            created: '2021-07-16T14:51:17+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1626447077251000',
            status: 'paid',
            total: 61,
            plus: 61,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 61,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'f905a1c4f359a65232271b0ec9643089',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1626446528893473',
            created: '2021-07-16T14:42:08+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1626446528893473',
            status: 'paid',
            total: 18,
            plus: 18,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 18,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '5eed0a87820e0b8f32da898deb279d85',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
    ],
    pageInfo: {
        hasNextPage: true,
        startCursor: null,
        hasPreviousPage: false,
        endCursor: 'MTYyNjQ0NjUyODAwMF9fNWVlZDBhODc4MjBlMGI4ZjMyZGE4OThkZWIyNzlkODU=',
    },
};
