export const context = {
    services: {
        refill: {
            alias: 'refill',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/998550/3b095c224131ca8faa87bfec5099a480c1fda911/svg',
            ids: {},
            name: 'Заправки',
            i18nKeyName: 'refill',
            url: 'https://zapravki.yandex.ru/',
            help: 'https://yandex.ru/chat#/user/3d8f0007-f610-914e-45f7-3eddaf3cc441',
        },
        plus_360: {
            alias: 'plus_360',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/994123/49ef2ec62be2f58b5f765b12cdfd9a04dd826e0e/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/994123/e4a8e3d3f8810a4cbebed1fc7f8952bd5df8d870/orig',
            ids: {},
            name: 'Подписка Яндекс 360',
            i18nKeyName: 'plus_360',
            url: 'https://mail360.yandex.ru',
            help: 'https://yandex.ru/support/mail/yandex-360.html',
        },
        praktikum: {
            alias: 'praktikum',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/994123/2029eb942ed84255579609bdd006f29bd6710d75/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/118781/57dd72c90f5871728407efd8c1e14495fee46761/orig',
            ids: {},
            name: 'Практикум',
            i18nKeyName: 'praktikum',
            url: 'https://practicum.yandex.ru/',
            help: 'https://yandex.ru/support/praktikum/feedback.html',
        },
        travel: {
            alias: 'travel',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/61205/e18dfaf6ae7e62e4a3be97bfd77e57ef33541404/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/994123/e1b838d55b6d1640a31323774f4f5a77a349766e/orig',
            ids: {},
            name: 'Путешествия',
            i18nKeyName: 'travel',
            url: 'https://travel.yandex.ru/hotels/',
            help: 'https://yandex.ru/support/travel/troubleshooting.html',
        },
        market: {
            alias: 'market',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/998550/ae1b6a5e3bd6905ee694fedc593e6ac497fee0e2/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/56833/35e70a852d59a7bd9c229bbf7d943f9155e65948/orig',
            ids: {},
            name: 'Маркет',
            i18nKeyName: 'market',
            url: 'https://pokupki.market.yandex.ru/my/orders',
        },
        afisha: {
            alias: 'afisha',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/128809/d4f71a94e2abd037b9e3862eca8824f6188ce7a9/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/60661/ea8ff7736616b4920852a9d4fc937fb2bbf8b8b8/orig',
            ids: {},
            name: 'Афиша',
            i18nKeyName: 'afisha',
            url: 'https://afisha.yandex.ru/',
        },
        kinopoisk: {
            alias: 'kinopoisk',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/49769/3c8752854e2d9fb4145b9a995cab8017321d774d/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/49769/e4070af0aefcd6fe2170ff14dbe5e58bad3e97d1/orig',
            ids: {},
            name: 'КиноПоиск',
            i18nKeyName: 'kinopoisk',
            url: 'https://hd.kinopoisk.ru/purchases',
        },
        plus: {
            alias: 'plus',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/e425107fb2cf831e2043b8a0ec86ae69835c3439/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/56833/fc16b55a67977c0dd19bfcb626e22ce83670ca93/svg',
            ids: {},
            name: 'Плюс',
            i18nKeyName: 'plus',
        },
        help_nko: {
            alias: 'help_nko',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/49769/b151a0f4a3796df437ebb45d913a4078289a8a7b/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/128809/6bf5ba7f303e3a6285667d61378b3133d1321a62/orig',
            ids: {},
            name: 'Помощь рядом',
            i18nKeyName: 'help_nearby',
            url: 'https://help.yandex.ru/roundup',
        },
        pay: {
            alias: 'pay',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/e425107fb2cf831e2043b8a0ec86ae69835c3439/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/56833/fc16b55a67977c0dd19bfcb626e22ce83670ca93/svg',
            ids: {},
            name: 'Pay',
            i18nKeyName: 'pay',
        },
        uslugi: {
            alias: 'uslugi',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/9da97fa2062af980929974de64343d47f49f72e8/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/998550/15a34c77fe975dabfe58f39f4e882d5ecc103d9e/orig',
            ids: {},
            name: 'Услуги',
            i18nKeyName: 'uslugi',
            url: 'https://uslugi.yandex.ru/my-orders',
            help: 'https://yandex.ru/chat#/user/3ea8c303-761b-9ce6-7a27-1a6cafa572f2',
        },
        lavka: {
            alias: 'lavka',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/49769/ae04ac827389ecf6786984250872830981ca4659/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/50064/908b53b0849408ce580da95a801c9a9ee130e255/orig',
            ids: {},
            name: 'Лавка',
            i18nKeyName: 'lavka',
            url: 'https://lavka.yandex.ru',
        },
        drive: {
            alias: 'drive',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/49769/622ce19ef4e08a91f0fe0ae410beb186e00401ba/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/994123/942397508f0efc846b2ca05239c317ab9e7507a7/orig',
            ids: {},
            name: 'Драйв',
            i18nKeyName: 'drive',
        },
        eats: {
            alias: 'eats',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/135516/a03749b25295017394bd4c8e225cf1042d2ae1aa/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/60661/97016dc040ed5391843ed1fd4ab6cda7c3301603/orig',
            ids: {},
            name: 'Еда',
            i18nKeyName: 'eats',
            url: 'https://eda.yandex.ru/',
        },
        taxi: {
            alias: 'taxi',
            iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/f69214ad5be2727a27383c8b25d3ec03bf783ba7/svg',
            splashUrl: '//avatars.mds.yandex.net/get-bunker/994123/48f990ccafa665862e43c83ac8c965dd212d99f2/orig',
            ids: {},
            name: 'Go',
            i18nKeyName: 'taxi',
            url: 'https://go.yandex/',
        },
    },
    discounts: [
        'virtual::kinopoisk_card_discounts',
        'virtual::kinopoisk_subs_discounts',
        'virtual::new_promocode',
    ],
    servicesOrder: [
        'plus',
        'plus_360',
        'market',
        'taxi',
        'lavka',
        'eats',
        'drive',
        'refill',
        'kinopoisk',
        'afisha',
        'uslugi',
        'praktikum',
        'travel',
    ],
    plusServiceData: {
        serviceName: 'plus',
        iconUrl: '//avatars.mds.yandex.net/get-bunker/118781/e425107fb2cf831e2043b8a0ec86ae69835c3439/svg',
        splashUrl: '//avatars.mds.yandex.net/get-bunker/56833/fc16b55a67977c0dd19bfcb626e22ce83670ca93/svg',
    },
};

export const test = {
    next: {
        created_keyset: '852c5ea28246cd260079e401ba86ab2a',
        order_id_keyset: 1625239560000,
    },
    orders: [
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-20T15:01:07+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '70.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '611fc3b3fbacea385e44a770',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629471676831045,
            trust_purchase_token: '0f8118ba2360f20f3350540efca8138e',
            merchant_uid: 1,
            updated: '2021-08-20T15:01:07.000+00:00',
            trust_payment_id: '611fc3b3fbacea385e44a770',
            items: [
                {
                    amount: '70.0',
                    price: '70.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-18T17:31:23+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '731.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '611d43eb8927ca0d0d39a604',
                payment_method: 'yandex_account_withdraw',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629307891012716,
            trust_purchase_token: '44e793c902e7ab9700d2158be0579d0f',
            merchant_uid: 1,
            updated: '2021-08-18T17:31:23.000+00:00',
            trust_payment_id: '611d43eb8927ca0d0d39a604',
            items: [
                {
                    amount: '731.0',
                    price: '731.0',
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-18T08:42:42+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '69.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '611cc802f9880122995b9bc3',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629276166456154,
            trust_purchase_token: 'd18fdf4a326baab6a1a874997b0d325f',
            merchant_uid: 1,
            updated: '2021-08-18T08:42:42.000+00:00',
            trust_payment_id: '611cc802f9880122995b9bc3',
            items: [
                {
                    amount: '69.0',
                    price: '69.0',
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-18T08:42:30+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '35.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '611cc7f699d6ef1d232f7325',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629276153418761,
            trust_purchase_token: 'a78303a1d2dde98520d7170e5f5d1d57',
            merchant_uid: 1,
            updated: '2021-08-18T08:42:30.000+00:00',
            trust_payment_id: '611cc7f699d6ef1d232f7325',
            items: [
                {
                    amount: '35.0',
                    price: '35.0',
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-17T19:50:47+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '54.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '611c13175a3951ccdfc51e46',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629229850862297,
            trust_purchase_token: 'c4f9f43383d7d320f3e2c69a1a6e29cf',
            merchant_uid: 1,
            updated: '2021-08-17T19:50:47.000+00:00',
            trust_payment_id: '611c13175a3951ccdfc51e46',
            items: [
                {
                    amount: '54.0',
                    price: '54.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-17T15:04:10+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '124',
            refunds: [],
            total: '398.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '611bcfea8927ca24e139a62f',
                payment_method: 'yandex_account_withdraw',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629212656292950,
            trust_purchase_token: 'c63efed7f286da78c3659f08aeb7c40a',
            merchant_uid: 1,
            updated: '2021-08-17T15:04:10.000+00:00',
            trust_payment_id: '611bcfea8927ca24e139a62f',
            items: [
                {
                    amount: '398.0',
                    price: '398.0',
                    image_path: null,
                    name: 'Перевозка пассажиров и багажа',
                    alias: 'ride',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-16T20:57:32+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '148.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '611ad13cbed21e023d5267a8',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1629147455657627,
            trust_purchase_token: 'a6b8ba785284cecf90ebca8740d6857b',
            merchant_uid: 1,
            updated: '2021-08-16T20:57:32.000+00:00',
            trust_payment_id: '611ad13cbed21e023d5267a8',
            items: [
                {
                    amount: '148.0',
                    price: '148.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-14T18:51:19+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '60.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '611810a78927ca36f55e9d29',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1628967083340091,
            trust_purchase_token: '05aecca1224b22516035a78f85a28818',
            merchant_uid: 1,
            updated: '2021-08-14T18:51:19.000+00:00',
            trust_payment_id: '611810a78927ca36f55e9d29',
            items: [
                {
                    amount: '60.0',
                    price: '60.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-13T16:30:02+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '86.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '61169e0bb9f8ed363409cacb',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1628872209065136,
            trust_purchase_token: '08552445c35b9e58e36835807baccd12',
            merchant_uid: 1,
            updated: '2021-08-13T16:30:02.000+00:00',
            trust_payment_id: '61169e0bb9f8ed363409cacb',
            items: [
                {
                    amount: '86.0',
                    price: '86.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-12T17:35:04+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '40.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '61155bc803c378dfafd24fc2',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1628789707129510,
            trust_purchase_token: '65f3d604b3fc1d17509c949a8334ca7b',
            merchant_uid: 1,
            updated: '2021-08-12T17:35:04.000+00:00',
            trust_payment_id: '61155bc803c378dfafd24fc2',
            items: [
                {
                    amount: '40.0',
                    price: '40.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-01T14:03:41+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '16.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '6106a9bddff13b71b67f0560',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1627826623945160,
            trust_purchase_token: '8e09b0dea3b5c867c255959c6b2b8f4f',
            merchant_uid: 1,
            updated: '2021-08-01T14:03:41.000+00:00',
            trust_payment_id: '6106a9bddff13b71b67f0560',
            items: [
                {
                    amount: '16.0',
                    price: '16.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-08-01T14:03:27+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '177.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '6106a9b003c37894964685cb',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1627826611490244,
            trust_purchase_token: '7bfc5d81e303afa940fc6c1724bcafdd',
            merchant_uid: 1,
            updated: '2021-08-01T14:03:27.000+00:00',
            trust_payment_id: '6106a9b003c37894964685cb',
            items: [
                {
                    amount: '177.0',
                    price: '177.0',
                    image_path: null,
                    name: 'CASHBACK_EMIT',
                    currency: 'RUB',
                    nds: '',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-24T12:34:07+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '29.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60fc08c07399013ad11c51f6',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1627130047678967,
            trust_purchase_token: 'e2ca9cdf92dbda3a03dc829ac27155d5',
            merchant_uid: 1,
            updated: '2021-07-24T12:34:07.000+00:00',
            trust_payment_id: '60fc08c07399013ad11c51f6',
            items: [
                {
                    amount: '29.0',
                    price: '29.0',
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-21T17:23:56+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '18.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60f8582d03c37806e5866e59',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1626888236946141,
            trust_purchase_token: '480a82c053719b546213429accd8a93d',
            merchant_uid: 1,
            updated: '2021-07-21T17:23:56.000+00:00',
            trust_payment_id: '60f8582d03c37806e5866e59',
            items: [
                {
                    amount: '18.0',
                    price: '18.0',
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-21T17:23:22+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '37.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60f8580a2fe0983f8cb99c1b',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1626888202575372,
            trust_purchase_token: 'd71357ed4319205b3036e8895b8f0d01',
            merchant_uid: 1,
            updated: '2021-07-21T17:23:22.000+00:00',
            trust_payment_id: '60f8580a2fe0983f8cb99c1b',
            items: [
                {
                    amount: '37.0',
                    price: '37.0',
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-16T14:51:17+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '61.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60f19ce583b1f208c67d4416',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1626447077251000,
            trust_purchase_token: 'f905a1c4f359a65232271b0ec9643089',
            merchant_uid: 1,
            updated: '2021-07-16T14:51:17.000+00:00',
            trust_payment_id: '60f19ce583b1f208c67d4416',
            items: [
                {
                    amount: '61.0',
                    price: '61.0',
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-16T14:42:08+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '18.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60f19ac02fe09829169a82c1',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1626446528893473,
            trust_purchase_token: '5eed0a87820e0b8f32da898deb279d85',
            merchant_uid: 1,
            updated: '2021-07-16T14:42:08.000+00:00',
            trust_payment_id: '60f19ac02fe09829169a82c1',
            items: [
                {
                    amount: '18.0',
                    price: '18.0',
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-07T19:51:18+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '629',
            refunds: [],
            total: '356.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60e605b694d5270f5bb05935',
                payment_method: 'yandex_account_withdraw',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1625687478537109,
            trust_purchase_token: 'bbc0379bb2f6c915b1ad3b9cdb86ff60',
            merchant_uid: 1,
            updated: '2021-07-07T19:51:18.000+00:00',
            trust_payment_id: '60e605b694d5270f5bb05935',
            items: [
                {
                    amount: '44.0',
                    price: '44.0',
                    image_path: null,
                    name: 'Сметана 15% «Брест-Литовск»',
                    currency: 'RUB',
                    nds: 'nds_10',
                },
                {
                    amount: '58.0',
                    price: '58.0',
                    image_path: null,
                    name: 'Минеральная вода «Ессентуки» № 4 газированная',
                    currency: 'RUB',
                    nds: 'nds_20',
                },
                {
                    amount: '108.0',
                    price: '108.0',
                    image_path: null,
                    name: 'Морковь мытая',
                    currency: 'RUB',
                    nds: 'nds_10',
                },
                {
                    amount: '68.0',
                    price: '68.0',
                    image_path: null,
                    name: 'Сметана 15% «Из Лавки» термостатная',
                    currency: 'RUB',
                    nds: 'nds_10',
                },
                {
                    amount: '78.0',
                    price: '78.0',
                    image_path: null,
                    name: 'Кетчуп Heinz томатный',
                    currency: 'RUB',
                    nds: 'nds_20',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-02T20:16:11+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '37.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60df740b954f6b3813322df5',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1625256971493865,
            trust_purchase_token: '6220223b63604ce9f24eb69f2f7e7d70',
            merchant_uid: 1,
            updated: '2021-07-02T20:16:11.000+00:00',
            trust_payment_id: '60df740b954f6b3813322df5',
            items: [
                {
                    amount: '37.0',
                    price: '37.0',
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
        {
            customer_uid: 4065249222,
            service_revision: 1,
            created: '2021-07-02T15:26:00+00:00',
            payments_order_id: 1,
            description: '',
            subservice_id: '610',
            refunds: [],
            total: '160.0',
            service_data: {
                trust_group_id: '',
                cashback_amount: 0,
                user_account: '',
                trust_payment_id: '60df3008f98801157b4be8c9',
                payment_method: 'yandex_account_topup',
                composite_payment_id: 0,
            },
            currency: 'RUB',
            service_merchant_id: 4065249222,
            order_revision: 1,
            order_id: 1625239560181807,
            trust_purchase_token: '852c5ea28246cd260079e401ba86ab2a',
            merchant_uid: 1,
            updated: '2021-07-02T15:26:00.000+00:00',
            trust_payment_id: '60df3008f98801157b4be8c9',
            items: [
                {
                    amount: '160.0',
                    price: '160.0',
                    image_path: null,
                    name: 'none',
                    currency: 'RUB',
                    nds: 'nds_none',
                },
            ],
            status: 'paid',
        },
    ],
};

export const expectation = {
    edges: [
        {
            id: '1629471676831045',
            created: '2021-08-20T15:01:07+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1629471676831045',
            status: 'paid',
            total: 70,
            plus: 70,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 70,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '0f8118ba2360f20f3350540efca8138e',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629307891012716',
            created: '2021-08-18T17:31:23+00:00',
            serviceId: '124',
            refunds: [],
            items: [],
            orderId: '1629307891012716',
            status: 'paid',
            total: 0,
            plus: -731,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_withdraw',
                    price: 731,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '44e793c902e7ab9700d2158be0579d0f',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629276166456154',
            created: '2021-08-18T08:42:42+00:00',
            serviceId: '124',
            refunds: [],
            items: [],
            orderId: '1629276166456154',
            status: 'paid',
            total: 69,
            plus: 69,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 69,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'd18fdf4a326baab6a1a874997b0d325f',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629276153418761',
            created: '2021-08-18T08:42:30+00:00',
            serviceId: '124',
            refunds: [],
            items: [],
            orderId: '1629276153418761',
            status: 'paid',
            total: 35,
            plus: 35,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 35,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'a78303a1d2dde98520d7170e5f5d1d57',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629229850862297',
            created: '2021-08-17T19:50:47+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1629229850862297',
            status: 'paid',
            total: 54,
            plus: 54,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 54,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'c4f9f43383d7d320f3e2c69a1a6e29cf',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629212656292950',
            created: '2021-08-17T15:04:10+00:00',
            serviceId: '124',
            refunds: [],
            items: [],
            orderId: '1629212656292950',
            status: 'paid',
            total: 0,
            plus: -398,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_withdraw',
                    price: 398,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'c63efed7f286da78c3659f08aeb7c40a',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1629147455657627',
            created: '2021-08-16T20:57:32+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1629147455657627',
            status: 'paid',
            total: 148,
            plus: 148,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 148,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'a6b8ba785284cecf90ebca8740d6857b',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1628967083340091',
            created: '2021-08-14T18:51:19+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1628967083340091',
            status: 'paid',
            total: 60,
            plus: 60,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 60,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '05aecca1224b22516035a78f85a28818',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1628872209065136',
            created: '2021-08-13T16:30:02+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1628872209065136',
            status: 'paid',
            total: 86,
            plus: 86,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 86,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '08552445c35b9e58e36835807baccd12',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1628789707129510',
            created: '2021-08-12T17:35:04+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1628789707129510',
            status: 'paid',
            total: 40,
            plus: 40,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 40,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '65f3d604b3fc1d17509c949a8334ca7b',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1627826623945160',
            created: '2021-08-01T14:03:41+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1627826623945160',
            status: 'paid',
            total: 16,
            plus: 16,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 16,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '8e09b0dea3b5c867c255959c6b2b8f4f',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1627826611490244',
            created: '2021-08-01T14:03:27+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1627826611490244',
            status: 'paid',
            total: 177,
            plus: 177,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 177,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '7bfc5d81e303afa940fc6c1724bcafdd',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1627130047678967',
            created: '2021-07-24T12:34:07+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1627130047678967',
            status: 'paid',
            total: 29,
            plus: 29,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 29,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'e2ca9cdf92dbda3a03dc829ac27155d5',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1626888236946141',
            created: '2021-07-21T17:23:56+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1626888236946141',
            status: 'paid',
            total: 18,
            plus: 18,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 18,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '480a82c053719b546213429accd8a93d',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1626888202575372',
            created: '2021-07-21T17:23:22+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1626888202575372',
            status: 'paid',
            total: 37,
            plus: 37,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 37,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'd71357ed4319205b3036e8895b8f0d01',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1626447077251000',
            created: '2021-07-16T14:51:17+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1626447077251000',
            status: 'paid',
            total: 61,
            plus: 61,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 61,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'f905a1c4f359a65232271b0ec9643089',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1626446528893473',
            created: '2021-07-16T14:42:08+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1626446528893473',
            status: 'paid',
            total: 18,
            plus: 18,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 18,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '5eed0a87820e0b8f32da898deb279d85',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1625687478537109',
            created: '2021-07-07T19:51:18+00:00',
            serviceId: '629',
            refunds: [],
            items: [],
            orderId: '1625687478537109',
            status: 'paid',
            total: 0,
            plus: -356,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_withdraw',
                    price: 356,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: 'bbc0379bb2f6c915b1ad3b9cdb86ff60',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1625256971493865',
            created: '2021-07-02T20:16:11+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1625256971493865',
            status: 'paid',
            total: 37,
            plus: 37,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 37,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '6220223b63604ce9f24eb69f2f7e7d70',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
        {
            id: '1625239560181807',
            created: '2021-07-02T15:26:00+00:00',
            serviceId: '610',
            refunds: [],
            items: [],
            orderId: '1625239560181807',
            status: 'paid',
            total: 160,
            plus: 160,
            currency: 'RUB',
            payments: [
                {
                    method: 'yandex_account_topup',
                    price: 160,
                    account: '',
                    currency: 'RUB',
                },
            ],
            refundOnly: false,
            purchaseToken: '852c5ea28246cd260079e401ba86ab2a',
            checksEnabled: false,
            service: {
                id: 'unknown',
                alias: 'unknown',
                name: 'Unknown',
                i18nKeyName: 'unknown',
                iconUrl: '',
            },
        },
    ],
    pageInfo: {
        hasNextPage: true,
        startCursor: null,
        hasPreviousPage: false,
        endCursor: 'MTYyNTIzOTU2MDAwMF9fODUyYzVlYTI4MjQ2Y2QyNjAwNzllNDAxYmE4NmFiMmE=',
    },
};
