import { IOrderItem } from '../../../../../types';
import { saftyParseFloat } from '../../../../lib/float';

const hiddenItemsName = ['Eda services', 'none'];

export function orderItemReducer(orderItem: Backend.OrderItem): IOrderItem {
    return {
        ...orderItem,
        price: saftyParseFloat(orderItem.amount),
        hidden: orderItem.hidden || hiddenItemsName.includes(orderItem.name),
    };
}

/*
    Есть часть транзакций, у которых в списке товаров есть плохие данные
    Не хотим такие показывать, поэтому просто их фильтруем
*/
export function orderItemFilter(orderItem: Backend.OrderItem) {
    if (!hiddenItemsName.includes(orderItem.name)) {
        return orderItem;
    }
}
