import * as url from 'url';
import type { UrlObject } from 'url';

import type { RequestHandler } from 'express';

import config from '../config';

const handler: RequestHandler = (req, res, next) => {
    if (req.path !== config.baseUrl || req.path.slice(-1) === '/') {
        return next();
    }

    const urlObject: UrlObject = {
        protocol: typeof req.headers['x-real-scheme'] === 'string' ? req.headers['x-real-scheme'] : 'https',
        hostname: req.hostname,
        pathname: req.path + '/',
        query: req.query as ANY,
    };

    return res.redirect(url.format(urlObject));
};

export default handler;
