import type { RequestHandler } from 'express';

import { expressBlackbox } from '@yandex-int/express-blackbox';

import config from '../config';
import MiscService from '../services/misc';

const handlers: RequestHandler[] = [
    expressBlackbox({
        aliases: '13',
        api: config.blackbox.url,
        getServiceTicket: (req) => req.tvm?.frontend.tickets?.blackbox?.ticket,
        getYaboxOptions: (req) => ({
            // Пробрасываем куку sessguard, чтобы работала аторизация на доменах passport(-test)?.yandex.ru
            sessguard: req.cookies.sessguard,
            get_family_info: 'yes',
        }),
        attributes: {
            lang: '34',
            havePlus: '1015',
        },
    }),
    (req, res, next) => {
        const miscService = new MiscService(req);

        if (req.blackbox && req.blackbox.status === 'VALID' && req.blackbox.userTicket) {
            const { uid, error } = req.blackbox;

            req.log.debug({
                type: 'blackbox',
                uid,
                error,
                connectionId: req.blackbox.raw.connection_id,
            }, 'Blackbox OK');

            return next();
        }

        req.log.debug({
            type: 'blackbox-0',
            method: req.method,
            error: req.blackbox?.error,
            status: req.blackbox?.status,
        }, 'blackbox-0');

        if (req.method === 'GET') {
            return req.blackbox?.status === 'NEED_RESET' ?
                res.redirect(miscService.passportAuthUpdateUrl) :
                res.redirect(miscService.passportAuthUrl);
        }

        return res.status(403).json({
            status: 'error',
            code: 'forbidden',
        });
    },
];

export const isYandexoid = (user: ExpressBlackbox.Result['raw'] | undefined) => {
    return Boolean(user?.aliases?.['13']);
};

export default handlers;
