import { get, toArray } from 'lodash';

import { parseUrlFactory } from './url';

import { isYandexoid } from '../blackbox';

export function getPayServicesEnabled(req: Express.Request): boolean {
    const { config } = req.bunker;

    return Boolean(
        config.payServicesEnabled ||
        isYandexoid(req.blackbox?.raw) ||
        config.payServicesWhitelist?.includes(req.blackbox?.uid),
    );
}

export function getPayServices(req: Express.Request): PayService[] {
    const { config } = req.bunker;

    const parseUrl = parseUrlFactory(req);

    return config.payServices.map((payService) => ({
        ...payService,
        iconUrl: parseUrl(payService.iconUrl),
        detailsIconUrl: parseUrl(payService.detailsIconUrl),
        splashUrl: parseUrl(payService.splashUrl),
    }));
}

export function getPayServicesPlusPromo(req: Express.Request): undefined | PayServicesPlusPromo {
    const { config } = req.bunker;
    const dateNow = new Date();
    const lang = 'ru';

    const promoData = get(config, ['payServicesPlusPromo', lang]);
    const [activeFrom, activeTo] = toArray(promoData.active);

    if (
        promoData &&
        activeFrom && activeTo &&
        new Date(activeFrom) < dateNow && dateNow < new Date(activeTo)
    ) {
        return {
            label: promoData.label,
            description: promoData.description,
        };
    }
}
