import { get } from 'lodash';

export function parseUrlFactory(req: Express.Request) {
    return function parseUrl(url: string | undefined) {
        if (!url) {
            return;
        }

        if (url.startsWith('bunker://')) {
            return get(req.bunker, url.slice(9).replace(/\//g, '.'), '');
        }

        return url.replace(/\$\{(uid|login)\}/g, (_, key) => {
            switch (key) {
                case 'login':
                    return req.services.user.authInfo.user.login || '';
                case 'uid':
                    return req.services.user.authInfo.user.uid || '';
                default:
                    return '';
            }
        });
    };
}
