import { AxiosError } from 'axios';
import { RequestHandler } from 'express';
import { isString } from 'lodash';

import logger from '../../lib/logger';

interface IError {
    response: {
        status: number;
        statusText: string;
        config: AxiosError['config'];
        data: unknown;
    };
}

export const apiErrorHandler: RequestHandler = (req, res) => (error: IError) => {
    try {
        const { response: { status, statusText, config: { method, baseURL, url }, data } } = error;

        let message = `${status} ${statusText} ← ${method?.toUpperCase()} ${baseURL}${url}`;

        if (data) {
            message += ` | ${isString(data) ? data : JSON.stringify(data)}`;
        }

        logger.error(message);
    } catch (err) {
        if (error?.response?.config?.headers) {
            delete error.response.config.headers;
        }

        logger.error(error);
    }

    return res.sendStatus(500);
};
