import type { ErrorRequestHandler } from 'express';

import static500 from './static500';

export const errorMiddlewareFactory = (type: string): ErrorRequestHandler => (err, req, res, _next) => {
    req.log.error({
        err,
        type,
    }, err.message || 'Unknown Error');

    return res.status(500).send(static500(req, err));
};

const handler: ErrorRequestHandler = errorMiddlewareFactory('global-error');

export default handler;
