import type { Request } from 'express';
import * as htmlescape from 'htmlescape';

import config from '../../config';
import { createExtractor } from '../../helpers';

function getYandexUid(req: Request) {
    try {
        return req.services.user.authInfo.user.yu || req.cookies.yandexuid;
    } catch {
        return undefined;
    }
}

export default function static500(req: Request, err: Error) {
    const extractor = createExtractor({
        entrypoints: ['error'],
    });

    return `
    <!doctype html>
    <html>
        <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
        <title>Ошибка обработки запроса</title>
        <style type="text/css">
            * {
            margin: 0;
            padding: 0;
            font-family: sans-serif;
            }

            .center {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            padding: 20px 0;
            box-sizing: border-box;
            }

            h1 {
            font-size: 128px;
            color: #e5e5e5;
            }

            .description {
            font-size: 15px;
            margin-top: 32px;
            text-align: center;
            }

            .description b {
            display: inline-block;
            }

            .button {
            background-color: #ffdb4d;
            font-size: 17px;
            font-weight: 500;
            padding: 18px;
            margin-top: 32px;
            cursor: pointer;
            }
        </style>
        </head>
        <body>
        <div class="center">
            <h1>
            500
            </h1>
            <div class="description">
            Ошибка обработки запроса. Код ошибки&nbsp—&nbsp<b>${req.id.slice(
        0,
        8,
    )}</b>.<br>Время&nbsp—&nbsp<b>${new Date().toISOString()}</b>.
            </div>
            <div class="button" id="reload-button">
            Перезагрузить страницу
            </div>
            ${extractor.getScriptTags().replace(/async/gm, '')}
            <script nonce="${req.nonce}">
                window.logErrorInit(${htmlescape(getYandexUid(req))}, ${htmlescape(req.uatraits.isTouch ? 'touch' : 'desktop')} ,${htmlescape(config.environment)});
                window.logError(new Error(${htmlescape(
        err.message || 'Unknown',
    )}), { source: 'backend', level: 'critical' });
                document.getElementById('reload-button').addEventListener('click', function () { window.location.reload(); });
            </script>
        </div>
        </body>
    </html>
    `;
}
