import type { RequestHandler } from 'express';
import * as uuid from 'uuid';

import config from '../config';

const handler: RequestHandler = (req, res, next) => {
    if (config.environment !== 'dev' && config.environment !== 'testing') {
        Object.defineProperty(req, 'ip', {
            value: req.get('x-real-ip'),
        });
    }

    req.id = req.get('x-request-id') || uuid.v4().split('-').join('');
    req.ssrId = req.get('x-ssr-id') || uuid.v4().split('-').join('');
    res.set('x-request-id', req.id);
    // res.set('x-timestamp', new Date().toISOString()); TODO: do i need this?

    return next();
};

export default handler;
