import * as path from 'path';

import { ChunkExtractor } from '@loadable/server';
import type { Response, Request } from 'express';
import { createElement } from 'react';
import type { CElement, Component } from 'react';

import type { ServerRenderProps } from '../../../types';
import config from '../../config';
import { createExtractor } from '../../helpers';

export type Initialized = {
    extractor: ChunkExtractor;
    root: CElement<{}, Component>;
};

const dev = config.environment === 'dev';
const rootPath = path.resolve(__dirname, '../../../../dist/root');
// eslint-disable-next-line @typescript-eslint/no-var-requires
const getRoot = !dev ? require(rootPath).Root : null;

export const getInitialized = async ({
    req,
    state,
    context,
    constants,
    initialSsrErrorMeta,
}: Omit<ServerRenderProps, 'req'> & { req: Request; res: Response }): Promise<Initialized> => {
    const extractor = createExtractor({
        entrypoints: ['main'],
    });

    const root = extractor.collectChunks(
        createElement(
            // eslint-disable-next-line @typescript-eslint/no-var-requires
            (getRoot || require(rootPath).Root)({
                req,
                state,
                context,
                constants,
                initialSsrErrorMeta,
            }),
        ),
    );

    return {
        root,
        extractor,
    };
};
