import { RequestHandler } from 'express';

import { parseTld } from '@yandex-int/express-langdetect/dist/lib/utils';

import config from '../../config';

// eslint-disable-next-line @typescript-eslint/no-var-requires
const crypto = require('crypto');

const md5 = (str: string) => crypto.createHash('md5').update(str).digest('hex');

const MS_IN_A_DAY = 1000 * 86400;

export const getSk = (yandexuid: string) => {
    return `y${md5(`0:${yandexuid}:${Math.floor(Date.now() / MS_IN_A_DAY)}`)}`;
};

export const setLang: RequestHandler = async (req, res) => {
    const {
        cookies: { yandexuid },
        query,
    } = req;

    const sk = getSk(yandexuid);

    const tld = parseTld(req, req.hostname);

    const href = `https://${config.yandex.host.replace(
        '{tld}',
        tld,
    )}/portal/set/lang/?sk=${sk}&retpath=${query.retpath}&intl=${query.lang}`;

    res.redirect(href);
};
