import type { RequestHandler } from 'express';

const handler: RequestHandler = (req, res, next) =>
    (req.services.user.current.uid || '') !== (req.header('x-visible-uid') || '') ?
        res.status(403).json({
            status: 'error',
            code: 'forbidden',
        }) :
        next();

export default handler;
