import { RequestHandler } from 'express';

export enum WebAmPlatform {
    IOS = 'ios',
    ANDROID = 'android',
}

const LANGS = ['ru', 'en', 'kk', 'be'];

export interface WebAmInitialData {
    app_platform: WebAmPlatform;
    /** appID-хоста (android), bundle id (iOS) хоста. */
    app_id: string;
    /** версия приложения хоста */
    app_version_name: string;
    /** версия AM */
    am_version_name: string;
    /** идентификатор устройства из метрики */
    device_id: string;
    /** идентификатор UI-темы */
    theme: 'light' | 'dark';
    /** язык АМ */
    lang: string;
    /** региональные настройки AM (язык русский, настройки Казахстан) */
    locale: string;
    /** Если есть текущий пользователь */
    uid?: string;
    /** Для входа на тв по qr */
    track_id?: string;
}

const webAmMiddleware: RequestHandler = (req, res, next) => {
    const {
        app_platform,
        lang,
    } = req.query as unknown as WebAmInitialData;

    res.locals.webAmParams = { app_platform, lang: LANGS.includes(lang) ? lang : 'en' };

    next();
};

export default webAmMiddleware;
