import { parseTld } from '@yandex-int/express-langdetect/dist/lib/utils';

import BaseService from './base';

import { arrayOf } from '../../helpers';
import type { Constants } from '../../types';
import config from '../config';

const LANGS = arrayOf<Constants['lang']>({
    ru: 0,
    en: 1,
    kk: 2,
    be: 3,
});

export default class MiscService extends BaseService {
    get url() {
        return `https://${this.req.get('host')}${this.req.originalUrl}`;
    }
    get passportAuthUpdateUrl() {
        return `https://${this.passportHost}/auth/update/?retpath=${encodeURIComponent(this.url)}`;
    }
    get passportAuthUrl() {
        return `https://${this.passportHost}/auth/?retpath=${encodeURIComponent(this.url)}&noreturn=1`;
    }
    get passportHost() {
        const tld = parseTld(this.req, this.req.hostname);

        return config.passport.host.replace('{tld}', tld);
    }
    get lang() {
        const lang = this.req.langdetect.id;

        return LANGS.includes(lang) ? lang : 'ru';
    }
}
