import type { Request } from 'express';

import BaseService from './base';

import type { AuthInfo } from '../../types';

export default class UserService extends BaseService {
    #authInfo: AuthInfo;

    constructor(req: Request) {
        super(req);
        this.init();
    }

    private init(): void {
        this.#authInfo = {
            user: {} as ANY,
        };
        const { uid, status, raw } = this.req.blackbox || {
            uid: null,
            status: null,
        };

        if (typeof uid !== 'string' || status !== 'VALID') {
            return;
        }

        this.#authInfo.user = {
            uid,
            yu: this.req.cookies.yandexuid,
            login: raw?.login,
        };
    }

    get authInfo() {
        return this.#authInfo;
    }

    get current() {
        return this.#authInfo.user;
    }
}
