type TODO = any;
type ANY = any;
type ID = string;
type Void = void;
type IsoDate = string & Tag<'YYYY-MM-DD'>;
type IsoDateTime = string & Tag<'YYYY-MM-DDThh:mm:ss.sssZ'>;
type IsoDateTimeShift = string & Tag<'YYYY-MM-DDThh:mm:ss.sss+hh:ss'>;

interface Tag<T extends string> {
    'nominal-type-tags': T;
}

interface Json {
    [key: string]: string | number | boolean | Date | Json | JsonArray;
}
interface JsonArray extends Array<string | number | boolean | Date | Json | JsonArray> {}

interface Date {
    toISOString<_>(): IsoDateTime;
}

interface ObjectConstructor {
    keys<S extends object>(o: S): (keyof S)[];
    entries<S extends string, T>(o: { [s in S]: T } | ArrayLike<T>): [S, T][];
}

interface Array<T> {
    includes(searchElement: any, fromIndex?: number): searchElement is T;
}

interface Window {
    ['yandex_metrika_callbacks2']?: Function[];
}

interface PlusServiceData {
    serviceName: string;
    iconUrl: string;
    splashUrl: string;
}
