#!/bin/bash

ENV_NAME=$(cat /etc/yandex/environment.type)

HOSTNAME="$(hostname -f)"
if [[ \
    $HOSTNAME == pass-stress-* || \
    $HOSTNAME == pass-load* || \
    $HOSTNAME == pass-mimino-* || \
    $HOSTNAME == pass-rc-* || \
    $HOSTNAME == pass-shg-* || \
    $HOSTNAME == pass-test-* || \
    $HOSTNAME == pass-yateam-test-* \
]]; then
    ENV_NAME="testing"  # to keep infra silent
fi

DEBIAN_PACKAGE="passport-sezam-front-fastcgi-config"
SERVICE_ID="932"  # https://infra.yandex-team.ru/services/932/environments
ENVIRONMENT_ID="1313"

REQUEST="{\"env\": \"${ENV_NAME}\", \"package\": \"${DEBIAN_PACKAGE}\", \"service_id\": ${SERVICE_ID}, \"environment_id\": ${ENVIRONMENT_ID}}"
#echo $REQUEST

curl https://passport-pocket-service.yandex-team.ru/webhooks/deploying_started \
    --silent \
    --connect-timeout 3 \
    --max-time 5 \
    --data "$REQUEST" \
    || true
