#!/usr/bin/env python3
# -*- coding: utf-8 -*-

import urllib.request
import json
import socket
import dns.resolver


class NetsProvider:
    __HBF_API_URL = "https://hbf.yandex.net"

    __resolver = dns.resolver.Resolver(configure=False)
    __resolver.nameservers = ["2a02:6b8::1:1"]

    def get_networklist_from_hbf(self, macro):
        try:
            f = urllib.request.urlopen(NetsProvider.__HBF_API_URL + "/macros/%s?format=json" % macro)
            return json.loads(f.read().decode('utf-8'))
        except urllib.error.HTTPError as e:
            print(e)

    def get_server_ips2(self, fqdn):
        server_ips = []
        for record in ["A", "AAAA"]:
            try:
                r = NetsProvider.__resolver.query(fqdn, record, raise_on_no_answer=False, tcp=True)
                ips = [] if not r.rrset else [ip.to_text() for ip in r]
                server_ips += ips
            except dns.resolver.NXDOMAIN:
                pass
        return server_ips

    def get_server_ips(self, fqdn):
        server_ips = []
        # Пытаемся получить IPv4 и IPv6 адреса
        for family in (socket.AF_INET, socket.AF_INET6):
            try:
                server_ips.append(socket.getaddrinfo(fqdn, 0, family)[0][4][0])
            except socket.error:
                # Например, в Финке нет IPv4 - getaddrinfo выкинет ошибку для socket.AF_INET
                # print('Warning: failed to discover server\'s IPv%d address' % (4 if family == socket.AF_INET else 6))
                continue
        return server_ips
