class NetworkDescriptionFilter:
    def make_unique_rates(self, macro_dictionary):
        ip_to_rate = {}
        unique_rates_dictionary = {}

        for net_dictionary in macro_dictionary.values():
            for ip, rate in net_dictionary.items():
                if ip in ip_to_rate:
                    if ip_to_rate[ip] < rate:
                        ip_to_rate[ip] = rate
                else:
                    ip_to_rate[ip] = rate

        for macro_name, net_dictionary in macro_dictionary.items():
            for ip, rate in net_dictionary.items():
                if macro_name in unique_rates_dictionary:
                    unique_rates_dictionary[macro_name][ip] = ip_to_rate[ip]
                else:
                    unique_rates_dictionary[macro_name] = {ip: ip_to_rate[ip]}

        return unique_rates_dictionary
