#pragma once

#include <passport/infra/libs/cpp/unistat/absolute.h>

#include <util/datetime/base.h>
#include <util/generic/string.h>
#include <util/system/types.h>

#include <condition_variable>
#include <mutex>
#include <queue>
#include <thread>

namespace NPassport::NDbPool {
    class TDbPool;
}

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NBb {
    class TAsyncDbWriter {
    public:
        TAsyncDbWriter(ui32 workerCount,
                       NDbPool::TDbPool* dbpool,
                       ui32 queueLimit,
                       const TDuration writeTimeout);
        ~TAsyncDbWriter();

        bool Append(const TString& request);

        void Stop();

        void AddUnistat(NUnistat::TBuilder& builder) const;

    private:
        void Writer(TString name);

    private:
        NDbPool::TDbPool* Db_;
        std::queue<TString> RequestQueue_;
        NUnistat::TSignalAbsolute<> RequestQueueSize_ = {"badauth_write.queue_size"};
        ui32 QueueLimit_;

        std::vector<std::thread> Threads_;
        std::mutex Mutex_;
        std::condition_variable Condition_;

        bool Stopped_ = false;

        TString WriterId_;

        const TDuration WriteTimeout_;
    };
}
