#pragma once

#include <util/generic/noncopyable.h>
#include <util/generic/string.h>

#include <memory>

namespace NPassport::NDbPool {
    class TDbPool;
    class TDbPoolCtx;
}

namespace NPassport::NXml {
    class TConfig;
}

namespace NPassport::NTvmCommon {
    class TServiceTickets;
}

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NTvmAuth {
    class TTvmClient;
}

namespace NPassport::NBb {
    class TAsyncDbWriter;
    class TBadauthHelper;
    class TBadauthSettings;
    class TIpAclWhitelist;

    class TBadauthFacade: TNonCopyable {
    public:
        explicit TBadauthFacade(std::shared_ptr<NTvmAuth::TTvmClient> tvmClient);
        ~TBadauthFacade();

        void Init(const NXml::TConfig& config,
                  const TString& xpathPrefix,
                  std::shared_ptr<NDbPool::TDbPoolCtx> ctx);

        bool IsWhitelisted(const TString& ip) const;

        TBadauthHelper FactoryWrapper(const TString& login,
                                      const TString& userIp,
                                      const TString& passwdHash,
                                      const TString& authType) const;

        void AddUnistat(NUnistat::TBuilder& builder) const;

        NDbPool::TDbPool* GetKolmogor() const;

    private:
        void InitBadAuthWhiteList(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitBadauthSettings(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitKolmogor(const NXml::TConfig& config,
                          const TString& xpathPrefix,
                          std::shared_ptr<NDbPool::TDbPoolCtx> ctx);

        std::shared_ptr<NTvmAuth::TTvmClient> TvmClient_;
        std::shared_ptr<NDbPool::TDbPool> KolmogorDb_;
        std::unique_ptr<TAsyncDbWriter> KolmogorWriter_;
        std::unique_ptr<TIpAclWhitelist> BadauthWhitelist_;
        std::unique_ptr<TBadauthSettings> BadauthSettings_;
    };

    using TBadauthFacadePtr = std::unique_ptr<TBadauthFacade>;

}
