#pragma once

#include "kolmogor.h"
#include "utils.h"

#include <util/datetime/base.h>
#include <util/generic/string.h>

#include <vector>

namespace NPassport::NDbPool {
    class TDbPool;
}

namespace NPassport::NBb {
    class TAsyncDbWriter;

    class TBadauthHelper {
        TBadauthHelper(NDbPool::TDbPool* kolmogorDb,
                       TAsyncDbWriter* kolmogorWriter,
                       const TBadauthSettings& badauthSettings);
        friend class TBadauthFacade;

    public:
        TBadauthCounts& Counts() {
            return Counts_;
        }

        // Increment badauth counters (for current user) and set up current value
        void IncrementCounters(TString& errMsg, size_t pwdLength);

        // Increment only authlog writes count
        void IncrementAuthlog(TString& errMsg);

        // Get total badauth counts (not just current counter)
        void GetTotalCounts(TString& errMsg);

    private:
        bool ParseResponseForKolmogorGet(TStringBuf body);
        TString QueryForKolmogorGet();

        TString QueryForKolmogorInc(TKolmogor::TKeys&& uniqKeys,
                                    TKolmogor::TKeys&& keys = {},
                                    TKolmogor::TKeys&& shortKeys = {});

        const TString& CreateKeyForLoginPwdIpAuthtype();
        const TString& CreateKeyForLoginIp();
        const TString& CreateKeyForPwdIp();
        const TString& CreateKeyForLogin();
        const TString& CreateKeyForPwd();
        const TString& CreateKeyForIp();

        // methods below are temporary, will be deleted after the experiment
        const TString& CreateKeyForLoginIpHalfIp();
        const TString& CreateKeyForPwdIpHalfIp();
        const TString& CreateKeyForIpHalfIp();

        const TString& CreateKeyForAuthlog();

        void SetLogin(const TString& login);

    private:
        NDbPool::TDbPool* KolmogorDb_;
        TAsyncDbWriter* KolmogorWriter_;

        TString Login_;
        TString UserIp_;
        TString HalfIp_;
        TString PasswdHash_;
        TString AuthType_;
        TBadauthCounts Counts_;
        const TBadauthSettings& BadauthSettings_;

        struct TKeys {
            TString LoginPwdIpAuthtype;
            TString LoginIp;
            TString PwdIp;
            TString Login;
            TString Pwd;
            TString Ip;
            TString Authlog;

            TString LoginIpHalfIp;
            TString PwdIpHalfIp;
            TString IpHalfIp;
        } Keys_;
    };
}
