#include "kolmogor.h"

#include <passport/infra/libs/cpp/dbpool/query.h>
#include <passport/infra/libs/cpp/json/writer.h>
#include <passport/infra/libs/cpp/utils/thread_local_id.h>

namespace NPassport::NBb {
    TString TKolmogor::PrepareGetQuery(const TKolmogor::TSpaces& spaces) {
        TString query;

        NJson::TWriter wr(query);
        NJson::TObject root(wr);

        for (const TSpace& sp : spaces) {
            NJson::TObject space(root, sp.Name);
            NJson::TArray keys(space, "keys");

            for (const TString& key : sp.Keys) {
                keys.Add(key);
            }
        }

        return query;
    }

    TString TKolmogor::PrepareIncQuery(const TKolmogor::TSpaces& spaces) {
        TString query;

        NJson::TWriter wr(query);
        NJson::TObject root(wr);

        for (const TSpace& sp : spaces) {
            NJson::TArray space(root, sp.Name);
            NJson::TObject obj(space);

            if (sp.IncIfLessThan) {
                obj.Add("inc_if_less_than", *sp.IncIfLessThan);
            }

            NJson::TArray keys(obj, "keys");

            for (const TString& key : sp.Keys) {
                keys.Add(key);
            }
        }

        return query;
    }

    static const TString CONTENT_TYPE = "Content-Type";
    static const TString CONTENT_TYPE_JSON = "application/json";
    static const TString EXTERNAL_REQ_ID = "X-Ext-Request-Id";
    static const TString KOLMOGOR_GET = "/2/get";
    static const TString KOLMOGOR_INC = "/2/inc";
    static const TString METHOD_POST = "POST";

    NDbPool::TQuery TKolmogor::CreateGetQuery(TString&& query) {
        return CreateQuery(std::move(query), KOLMOGOR_GET);
    }

    NDbPool::TQuery TKolmogor::CreateIncQuery(TString&& query) {
        return CreateQuery(std::move(query), KOLMOGOR_INC);
    }

    NDbPool::TQuery TKolmogor::CreateQuery(TString&& query,
                                           const TString& path) {
        NDbPool::TQuery httpQuery(path);
        httpQuery.SetHttpMethod(METHOD_POST);

        httpQuery.AddHttpHeader(CONTENT_TYPE, CONTENT_TYPE_JSON);
        httpQuery.AddHttpHeader(EXTERNAL_REQ_ID, NUtils::GetThreadLocalRequestId());

        httpQuery.SetHttpBody(std::move(query));

        return httpQuery;
    }
}
