#pragma once

#include <library/cpp/containers/stack_vector/stack_vec.h>

#include <util/generic/string.h>

#include <optional>

namespace NPassport::NDbPool {
    class TQuery;
}

namespace NPassport::NBb {
    class TKolmogor {
    public:
        struct TKeys: TStackVec<TString, 8>, TMoveOnly { // NOLINT(bugprone-exception-escape)
        };

        struct TSpace { // NOLINT(bugprone-exception-escape)
            TString Name;
            TKeys Keys;
            std::optional<ui64> IncIfLessThan;
        };
        using TSpaces = TStackVec<TSpace, 3>;

        static TString PrepareGetQuery(const TSpaces& spaces);
        static TString PrepareIncQuery(const TSpaces& spaces);

        static NDbPool::TQuery CreateGetQuery(TString&& query);
        static NDbPool::TQuery CreateIncQuery(TString&& query);

    private:
        static NDbPool::TQuery CreateQuery(TString&& query,
                                           const TString& path);
    };
}
