#pragma once

#include <util/generic/string.h>
#include <util/string/builder.h>
#include <util/string/cast.h>
#include <util/system/types.h>

#include <ctime>
#include <unordered_set>
#include <vector>

namespace NPassport::NBb {
    class TBadauthSettings {
    public:
        TString Str() const;

        ui64 RepeatedRequestLimit = 0;
        ui64 LoginPwdIpAuthHr = 0;
        ui64 LoginIpHr = 0;
        ui64 PwdIpHr = 0;
        ui64 LoginHrCombined = 0;
        ui64 PwdHrCombined = 0;
        ui64 IpHrCombined = 0;
        ui64 IpHr = 0;
        ui64 IpMin = 0;

        ui64 AuthlogLimit = 0;

        TString SpaceNameCommon;
        TString SpaceNameShort;
        TString SpaceNameUniq;
        size_t PwdLength = 0;
    };

    class TBadauthCheckResult {
    public:
        TBadauthCheckResult() = default;

        TBadauthCheckResult(const TString& rule, ui64 count)
            : Rule(rule)
            , Count(IntToString<10>(count))
        {
        }

        TBadauthCheckResult(const TString& rule, ui64 count1, ui64 count2)
            : Rule(rule)
            , Count(TStringBuilder() << count1 << "," << count2)
        {
        }

        bool IsOk() const {
            return Rule.empty() && Count.empty();
        }

    public:
        TString Rule;
        TString Count;
    };

    class TBadauthCountersChunk;

    class TBadauthCounts {
    public:
        TBadauthCounts(const TBadauthSettings& settings);

        TBadauthCheckResult RepeatInLimits(TString& authlogMsg);
        TBadauthCheckResult CountsInLimits(bool whitelisted, size_t pwdLength, TString& authlogMsg) const;
        bool AuthLogInLimits() const;

        TBadauthCheckResult CountsInLimitsHalfIp(bool whitelisted, size_t pwdLength, TString& authlogMsg) const;
        TString Str() const;
        void GetValues(TBadauthCountersChunk& chunk) const;

        bool IsOk() const;

        void SetLogin(const TString& login);

    public:
        // counter values
        ui64 RepeatCount = 0;
        ui64 LoginIp = 0;
        ui64 PwdIp = 0;
        ui64 Login = 0;
        ui64 Pwd = 0;
        ui64 Ip = 0;
        ui64 IpShort = 0;

        ui64 LoginIpHalfIp = 0;
        ui64 PwdIpHalfIp = 0;
        ui64 IpHalfIp = 0;
        ui64 IpShortHalfIp = 0;

        ui64 Authlog = 0;

        // increment or not the counters
        bool IncrementRepeated = true;

        // failure flag
        bool Failed = false;

    private:
        const TBadauthSettings& Settings_;
        TString LoginStr_;
    };
}
