#pragma once

#include "grants/consumer_info.h"
#include "misc/login_type.h"
#include "misc/sessguard_options.h"
#include "misc/user_ticket_cache.h"
#include "misc/ya_domains.h"

#include <passport/infra/libs/cpp/auth_core/environment.h>

#include <library/cpp/geobase/lookup.hpp>
#include <library/cpp/string_utils/secret_string/secret_string.h>
#include <library/cpp/tvmauth/client/facade.h>

#include <util/generic/hash_set.h>

#include <memory>
#include <unordered_set>
#include <vector>

class TBlackboxHelper;

namespace NPassport::NAuth {
    class TOAuthTokenParser;
    class TPublicIdEncryptor;
    class TSessGuardParser;
    class TSessionParser;
    class TSessionSigner;
}

namespace NPassport::NDbPool {
    class TDbPool;
    class TDbPoolCtx;
}

namespace NPassport::NUtils {
    class TFileLogger;
}

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NJuggler {
    class TStatus;
}

namespace NPassport::NTvmCommon {
    class TPrivateKey;
}

namespace NPassport::NCommon {
    class TRequest;
}

namespace NPassport::NXml {
    class TConfig;
}

namespace NPassport::NBb {
    class IRateLimiter;
    class IStaffInfo;
    class TAnonymiser;
    class TAttributesSettings;
    class TAuthLog;
    class TBadauthFacade;
    class TDbFetcher;
    class TDbFieldsConverter;
    class TDbFieldsSettings;
    class TDbProfile;
    class TDomain;
    class TDomainFetcher;
    class THostsList;
    class TIpGrants;
    class TIpComparator;
    class TLRandomsDumper;
    class TOAuthConfig;
    class TPartitionsSettings;
    class TPassportWrapper;
    class TPasswordChecker;
    class TPerimeterWrapper;
    class TRangedShardsMap;
    class TSessKillWrapper;
    class TSigner;
    class TStaffInfo;
    class TStopWordsList;
    class TSyntheticAttributes;
    class TStringSet;
    class TTotpProfile;
    class TTskvLog;
    class TTvmGrants;
    class TUsernetsList;
    class TValidator;

    namespace NTotp {
        class TService;
        class TServiceRfc;
    }
    class TTotpEncryptor;

    enum class ENetworkKind {
        Internal,
        Robot,
        External,
    };

    class TBlackboxImpl {
    public:
        TBlackboxImpl();
        ~TBlackboxImpl();

        void Init(const NXml::TConfig& config, const TString& xpathPrefix);

    public: // for monitorings
        void AddUnistat(NUnistat::TBuilder& builder);
        void AddExtendedUnistatForDbPool(NUnistat::TBuilder& builder);
        time_t GetIpGrantsMTime() const;
        time_t GetTvmGrantsMTime() const;
        bool DbOk(TString& msgaccum) const;
        TString DbpoolStats() const;
        TString DbpoolExtendedStats() const;
        NJuggler::TStatus GetJugglerStatus() const;

    public: // buisness logic
        TConsumerInfo GetConsumer(NCommon::TRequest& req) const;

        std::unique_ptr<TValidator> CreateValidator(const NCommon::TRequest& request, TDbFieldsConverter& conv) const;
        TDbFetcher CreateDbFetcher() const;

        static void CheckGrants(const NCommon::TRequest& req, const TConsumer& consumer, TBlackboxMethods::EMethod method);

        ENetworkKind CheckYandexIp(const TString& ip,
                                   const NCommon::TRequest& req,
                                   const TStringBuf description = {}) const;
        static TString AccessDeniedMessage(const TConsumer& consumer, const TString& ip, const TString& method);

        bool IsPhoneAlias(TString& login, const TString& domain, const TString& country, bool allowUTF = false) const;
        ELoginType TranslateLoginSids(TString& login, TString& sid, TDomain& pddDomain, const TString& country) const;
        bool IsYaTeam() const;
        bool IsStopWord(const TString& word) const;

        bool IsMail4domainsUid(const TString& uid) const;
        bool IsMdaDomain(const TString& domain) const;
        const TSessGuardOptions& GetGuardSpaceOptions(const TString& guardspace) const;
        bool IsAllowedAuthtype(const TString& type) const;
        bool IsExternalRobotAllowed(ui64 uid) const;

    public: // getters
        bool SupportBantime() const {
            return SupportBanTime_;
        }

        const NAuth::TSessionSigner& SessionSigner() const {
            return *SessSigner_;
        }

        const NAuth::TSessionParser& SessionParser() const {
            return *SessParser_;
        }

        const NAuth::TSessGuardParser& SessGuardParser() const {
            return *SessguardParser_;
        }

        const NAuth::TOAuthTokenParser& OauthParser() const {
            return *OauthParser_;
        }

        const NAuth::TPublicIdEncryptor* PublicIdEncryptor() const {
            return PublicIdEncryptor_.get();
        }

        const TSigner& Signer() const {
            return *Signer_;
        }

        NAuth::EEnvironmentType OAuthEnv() const {
            return OAuthEnv_;
        }

        const TIpComparator& IpComparator() const {
            return *IpComparator_;
        }

        const TPartitionsSettings& PartitionsSettings() const {
            return *PartitionsSettings_;
        }

        const TAttributesSettings& AttributeSettings() const {
            return *AttrSettings_;
        }

        const TDbFieldsSettings& DbFieldSettings() const {
            return *DbfieldsSettings_;
        }

        const NUtils::TFileLogger* LoginLogger() const {
            return LoginLogger_.get();
        }

        const TAuthLog* AuthLogger() const {
            return AuthLogger_.get();
        }

        const TTskvLog* StatboxLogger() const {
            return StatboxLogger_.get();
        }

        NDbPool::TDbPool& CentralDb() const {
            return *CentralDb_;
        }

        const TRangedShardsMap& ShardsMap() const {
            return *ShardsMap_;
        }

        NDbPool::TDbPool& CentralSlowDb() const {
            return *CentralSlowDb_;
        }

        const NTvmAuth::TTvmClient& TvmClient() const;

        ui32 MinCharsCountBeforeWildcard() const {
            return MinCharsCountBeforeWildcard_;
        }

        const TString& HostId() const {
            return HostId_;
        }

        const TString& MailHostId() const {
            return MailHostId_;
        }

        unsigned MultisessionUserLimit() const {
            return MultisessionUserLimit_;
        }

        bool IsYandexIpCheckEnabled() const {
            return EnableYandexIpCheck_;
        }

        bool IsStressSessionAllowed() const {
            return AllowStressCookies_;
        }

        bool IsLiteSessionAllowed() const {
            return SupportLiteSess_;
        }

        bool BlockCalendarByPassword() const {
            return BlockCalendarByPassword_;
        }

        unsigned MultisecretLimit() const {
            return MultisecretLimit_;
        }

        TSessKillWrapper* SesskillWrapper() const {
            return SessKill_.get();
        }

        TPassportWrapper* PassportWrapper() const {
            return Passport_.get();
        }

        const TPasswordChecker& PasswordChecker() const {
            return *PasswdChecker_;
        }

        const TBadauthFacade* Badauth() const {
            return BadauthFacade_.get();
        }

        const TPerimeterWrapper* PerimeterWrapper() const {
            return Perimeter_.get();
        }

        const IStaffInfo* StaffInfo() const;

        const TAnonymiser* Anonymiser() const {
            return Anonymiser_.get();
        }

        const TDomainFetcher& HostedDomains() const {
            return *HostedDomains_;
        }

        const TYandexDomains& YandexDomains() const {
            return YandexDomains_;
        }

        const THostsList& Hosts() const {
            return *Hosts_;
        }

        const TTotpEncryptor* TotpEncryptor() const {
            return TotpEncryptor_.get();
        }

        unsigned StrongPwdExpireTime() const {
            return StrongpwdExpireTime_;
        }

        unsigned YakeyBackupExpireTime() const {
            return YakeyBackupExpireTime_;
        }

        time_t FullFioInPublicNameStartTime() const {
            return FullFioInPublicNameStartTime_;
        }

        time_t PublicProfileProtectionStartTime() const {
            return PublicProfileProtectionStartTime_;
        }

        const TOAuthConfig& OauthConfig() const {
            return *OauthConfig_;
        }

        const NTvmCommon::TPrivateKey& TvmPrivateKeys() const {
            return *TvmPrivateKey_;
        }

        NTvmAuth::EBlackboxEnv UserTicketEnv() const {
            return Env_;
        }

        ui32 UserTicketTtl() const {
            return UserTicketTtl_;
        }

        TUserTicketCache* UserTicketCacheForOAuth() const {
            return UserTicketCacheForOAuth_.get();
        }

        TUserTicketCache* UserTicketCacheForSessionid() const {
            return UserTicketCacheForSessionid_.get();
        }

        TUserTicketCache* UserTicketCacheForUserTicket() const {
            return UserTicketCacheForUserTicket_.get();
        }

        ui32 UserTicketCacheTtl() const {
            return UserTicketCacheTtl_;
        }

        const NTotp::TService& TotpService() const {
            return *TotpService_;
        }

        const NTotp::TServiceRfc* TotpServiceRfc() const {
            return TotpServiceRfc_.get();
        }

        unsigned MultiuserLimit() const {
            return MultiuserLimit_;
        }

        unsigned MultiuserWarnLimit() const {
            return MultiuserWarnLimit_;
        }

        unsigned FindByPhoneNumbersLimit() const {
            return FindByPhoneNumbersLimit_;
        }

        ui64 DeviceSignatureMaxAge() const {
            return DeviceSignatureMaxAge_;
        }

        const IRateLimiter& RateLimiter() const {
            return *RateLimiter_;
        }

        ui16 FamilyKidsLimit() const {
            return FamilyKidsLimit_;
        }

        TZtStringBuf PasswordHashSecret() const {
            return PasswordHashSecret_.Value();
        }

        ui32 LrcsTtl() const {
            return LrcsTtl_;
        }

    private:
        void InitLoggers(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitDb(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitRandomKeys(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitKeyspaces(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitAcl(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitGeobase(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitYandexIpList(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitMailDomains(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitAnonymiser(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitPerimeter(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitStaffInfo(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitOAuth(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitStrongPwdLimits(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitBadauth(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitSessKillWrapper(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitPassportWrapper(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitStopWords(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitMail4Domains(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitHosts(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitPartitionsSettings(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitAttrSettings(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitDbFieldsSettings(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitTotpSettings(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitRfcTotpChecker(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitTvm(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitTicketSigner2(const NXml::TConfig& config, const TString& xpathPrefix, const NTvmAuth::NTvmApi::TClientSettings& settings);
        void InitPddRanges(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitPasswordChecker(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitPublicIdSettings(const NXml::TConfig& config, const TString& xpathPrefix);
        static void InitExperiments(const NXml::TConfig& config, const TString& xpathPrefix);

        void InitMiscOptions(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitLRandomsDumper(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitSigner(const NXml::TConfig& config, const TString& xpathPrefix);

        void InitUserTicketCache(const NXml::TConfig& config, const TString& xpathPrefix);
        void InitRateLimiter(const NXml::TConfig& config, const TString& xpathPrefix);

        void SetHostId(const TString& id);

    private:
        std::unique_ptr<NUtils::TFileLogger> LoginLogger_;
        std::unique_ptr<TAuthLog> AuthLogger_;
        std::unique_ptr<TTskvLog> StatboxLogger_;
        std::unique_ptr<TTskvLog> OauthLogger_;

        std::unique_ptr<TPartitionsSettings> PartitionsSettings_;
        std::unique_ptr<TAttributesSettings> AttrSettings_;
        std::unique_ptr<TDbFieldsSettings> DbfieldsSettings_;
        std::unique_ptr<TIpGrants> IpGrants_;
        std::unique_ptr<TUsernetsList> UsernetsList_;
        std::unique_ptr<TTvmGrants> TvmGrants_;

        std::shared_ptr<NDbPool::TDbPool> CentralDb_;
        std::unique_ptr<TRangedShardsMap> ShardsMap_;

        std::unique_ptr<TBadauthFacade> BadauthFacade_;

        std::unique_ptr<TStaffInfo> StaffInfo_;
        std::unordered_set<ui64> AllowedExternalRobotUids_;

        std::unique_ptr<TPerimeterWrapper> Perimeter_;
        std::unique_ptr<TAnonymiser> Anonymiser_;
        std::unique_ptr<TSessKillWrapper> SessKill_;
        std::unique_ptr<TPassportWrapper> Passport_;

        bool SupportBanTime_ = false;

        std::shared_ptr<NDbPool::TDbPool> CentralSlowDb_;
        ui32 MinCharsCountBeforeWildcard_ = 4;

        std::unique_ptr<TDomainFetcher> HostedDomains_;
        std::unique_ptr<TStopWordsList> StopWords_;

        std::unique_ptr<THostsList> Hosts_;
        bool EnablePhoneAliases_ = true;
        std::unique_ptr<TStringSet> DigitLogins_;
        THashMap<TString, TSessGuardOptions> GuardSpaceOptions_;
        TSessGuardOptions DefaultGuardSpaceOptions_;
        THashSet<TString> AllowedAuthtypes_;

        TString HostId_;
        std::unique_ptr<TStringSet> MdaDomains_;
        TYandexDomains YandexDomains_;
        ui64 Mail4domainsFirstUid_ = 1130000000000000ll;
        ui64 Mail4domainsLastUid_ = 2260000000000000ll;
        TString MailHostId_;
        ui16 FamilyKidsLimit_ = 0;

        std::unique_ptr<TOAuthConfig> OauthConfig_;

        unsigned StrongpwdExpireTime_;
        unsigned YakeyBackupExpireTime_;
        bool EnableYandexIpCheck_ = false;
        bool AllowStressCookies_ = false;
        unsigned MultisessionUserLimit_ = 5;
        unsigned MultisecretLimit_ = 20;
        unsigned MultiuserWarnLimit_ = 0;
        unsigned MultiuserLimit_ = 0;
        unsigned FindByPhoneNumbersLimit_ = 0;
        time_t FullFioInPublicNameStartTime_ = 0;
        time_t PublicProfileProtectionStartTime_ = 0;
        bool BlockCalendarByPassword_ = false;
        NSecretString::TSecretString PasswordHashSecret_;

        std::unique_ptr<TPasswordChecker> PasswdChecker_;

        std::unique_ptr<TIpComparator> IpComparator_;
        std::unique_ptr<NGeobase::TLookup> Lookup_;

        std::unique_ptr<NTotp::TService> TotpService_;
        std::unique_ptr<NTotp::TServiceRfc> TotpServiceRfc_;
        std::unique_ptr<TTotpEncryptor> TotpEncryptor_;
        std::unique_ptr<TSyntheticAttributes> SyntheticAttrs_;

        // Ticket signer
        ui32 TvmSelfId_ = 0;
        std::shared_ptr<NTvmAuth::TTvmClient> TvmClient_;
        std::unique_ptr<NTvmCommon::TPrivateKey> TvmPrivateKey_;
        NTvmAuth::EBlackboxEnv Env_ = NTvmAuth::EBlackboxEnv::Test;
        ui32 UserTicketTtl_ = 0;

        NCache::TContextPtr<NTicketSigner::TUserSigner, TString> UserTicketCacheCtx_;
        std::unique_ptr<TUserTicketCache> UserTicketCacheForOAuth_;
        std::unique_ptr<TUserTicketCache> UserTicketCacheForSessionid_;
        std::unique_ptr<TUserTicketCache> UserTicketCacheForUserTicket_;
        ui32 UserTicketCacheTtl_ = 0;

        bool SupportLiteSess_ = true;

        std::unique_ptr<NAuth::TSessionSigner> SessSigner_;
        std::unique_ptr<NAuth::TSessionParser> SessParser_;
        std::unique_ptr<NAuth::TSessGuardParser> SessguardParser_;
        std::unique_ptr<NAuth::TOAuthTokenParser> OauthParser_;
        std::unique_ptr<NAuth::TPublicIdEncryptor> PublicIdEncryptor_;
        std::unique_ptr<TSigner> Signer_;
        NAuth::EEnvironmentType OAuthEnv_ = NAuth::EEnvironmentType::Testing;

        std::shared_ptr<NDbPool::TDbPoolCtx> DbCtx_;

        std::unique_ptr<TLRandomsDumper> LrandomsDumper_;

        ui64 DeviceSignatureMaxAge_ = 0;

        std::unique_ptr<IRateLimiter> RateLimiter_;

        ui32 LrcsTtl_ = 0;
    };
}
