#pragma once

#include <util/datetime/base.h>
#include <util/generic/string.h>

#include <vector>

namespace domainlists_proto {
    class Domain;
}

namespace NPassport::NBb {
    class TDomain {
    public:
        using TSlaves = std::vector<TString>;

        struct TOptions {
            TString OrganizationName;
            TString OrganizationId;

            TString RawOptions;

            TInstant Glogout;
        };

        struct TDomainParams {
            TString Id;
            TString Master = "0";
            TString Name;
            bool Ena = false;
            bool Mx = false;
            TString AdminUid;
            TString DefaultUid;
            TString BornDate = "0000-00-00 00:00:00";
            TOptions Options;
        };

        TDomain() = default;
        TDomain(TDomainParams&& params);
        TDomain(const domainlists_proto::Domain& d);

        // disk cache
        void Serialize(domainlists_proto::Domain& out) const;

        const TString& Id() const {
            return Id_;
        }

        bool IsFound() const {
            return !Id_.empty();
        }

        const TString& Master() const {
            return Master_;
        }

        bool IsSlave() const {
            return Master_ != "0";
        }

        const TString& AsciiName() const {
            return AsciiName_;
        }

        const TString& UtfName() const {
            return UtfName_;
        }

        bool Ena() const {
            return Ena_;
        }

        bool Mx() const {
            return Mx_;
        }

        const TString& AdminUid() const {
            return AdminUid_;
        }

        const TString& DefaultUid() const {
            return DefaultUid_;
        }

        const TString& BornDate() const {
            return BornDate_;
        }

        const TString& OrganizationName() const {
            return Options_.OrganizationName;
        }

        const TString& OrganizationId() const {
            return Options_.OrganizationId;
        }

        TInstant Glogout() const {
            return Options_.Glogout;
        }

        const TString& RawOptions() const {
            return Options_.RawOptions;
        }

        const TSlaves& Slaves() const {
            return Slaves_;
        }

        void AddSlave(const TString& slave);
        void DropSlave(const TString& slave);
        void UpdateDomain(TDomain&& d);

        bool operator==(const TDomain& o) const; // for tests

        //// Domain may be transport for some variables
        // Set alt domain id
        void SetId(const TString& id) {
            Id_ = id;
        }

        // Do not search default uid for domain
        void ClearDefaultUid() {
            DefaultUid_.clear();
        }

        // Pretend that it is not found - for alt domains
        void ClearId() {
            Id_.clear();
        }
        ////

    private:
        TString Id_;
        TString Master_;
        TString UtfName_;
        TString AsciiName_;
        bool Ena_ = false;
        bool Mx_ = false;
        TString AdminUid_;
        TString DefaultUid_;
        TString BornDate_; // TODO: make TInstant: PASSP-33987
        TOptions Options_;
        TSlaves Slaves_;
    };
}
