#pragma once

#include "domain_list.h"

#include <util/generic/string.h>

#include <deque>

namespace NPassport::NDbPool {
    struct TRow;
}

namespace NPassport::NBb {
    class TDomainListBuilderBase {
    public:
        TDomainListBuilderBase(TDomainCache& cache);

        void Finish();

        static TDomain::TOptions ReadDomainOptions(const TString& options);

    protected:
        TDomainCache& Out_;
        std::deque<TDomain> Slaves_;
    };

    class TDomainListBuilder: public TDomainListBuilderBase {
    public:
        using TDomainListBuilderBase::TDomainListBuilderBase;

        static TString MakeQuery(const TString& domId, const size_t limit);

        void Reserve(size_t size);
        TString AddRowAndGetDomId(NDbPool::TRow&& row);
        void SetLastEventId(const TString& id);
    };

    class TDomainListUpdater: public TDomainListBuilderBase {
    public:
        using TDomainListBuilderBase::TDomainListBuilderBase;

        void SetLogging(bool val);
        static TString MakeQuery(const TString& eventId);

        enum class Event {
            GoNext,
            Reload
        };

        Event AddRow(const NDbPool::TRow& row);

    private:
        ui32 LastEventIdInt_ = 0;
    };
}
