#pragma once

#include "domain_builder.h"
#include "idomain_fetcher.h"

#include <passport/infra/libs/cpp/dbpool/value.h>
#include <passport/infra/libs/cpp/utils/shared_state.h>

#include <util/datetime/base.h>
#include <util/generic/string.h>

namespace NPassport::NDbPool {
    class TDbPool;
}

namespace NPassport::NBb {
    struct TDomainFetcherSettings {
        long PageSize = 100;
        long PageRetryCount = 3;
        TString CacheFile = {};
        TDuration CacheFileWritePeriod = TDuration::Hours(1);
    };

    class TDomainFetcher: public IDomainFetcher {
    public:
        TDomainFetcher(
            NDbPool::TDbPool&,
            const TDomainFetcherSettings& settings);

        ~TDomainFetcher() override;

        TResult Find(const TString& domain, EPolicy policy = EPolicy::ReplaceAliasWithMaster) const;
        TResult FindById(const TString& domid, EPolicy policy = EPolicy::ReplaceAliasWithMaster) const override;
        TResult FindInDb(const TString& domain, bool useDomid = false, EPolicy policy = EPolicy::ReplaceAliasWithMaster) const override;

    protected:
        void InitFromFile();
        void InitFromDb();

        static TDomainCachePtr LoadFromFile(const TString& filename);
        static TDomainCache LoadFromProto(const TString& body);

        static void SaveToFile(const TDomainCache& cache, const TString& filename);
        static TString SerializeToProto(const TDomainCache& cache);

        // Does the job of list loading. Throws on error
        TDomainCachePtr Load() const;
        void SaveLoadedCache(TDomainCachePtr cache);
        void Run();

        static const TDomain* FindDomItem(const TDomain* domain, const TDomainList& list, EPolicy policy);

        // Updates list according to new events found on the domains_events table;
        // throws on error
        void Update();
        bool UpdateWithRows(const NDbPool::TTable& table);

        NDbPool::TTable GetUpdatingResult(const TString& query) const;

    public:
        enum EStatus {
            status_Need_Reload,
            status_Current
        };

    protected:
        static EStatus ProcessUpdatingResult(const NDbPool::TTable& table, TDomainListUpdater& updater);

    protected:
        NDbPool::TDbPool& Dbp_;

        NUtils::TSharedState<TDomainCache> Cache_;
        TDomainCachePtr SecondaryCache_;

        const TDomainFetcherSettings Settings_;
        TInstant NextCacheFileWrite_;
    };
}
