#pragma once

#include "domain.h"

#include <util/generic/string.h>

#include <memory>
#include <unordered_map>

namespace domainlists_proto {
    class Cache;
}

namespace NPassport::NBb {
    class TDomainList {
        // map: "domain id" -> domain data
        using TDomlistById = std::unordered_map<TString, TDomain>;
        // map: "domain name" -> "domain id"
        using TDomlistByName = std::unordered_map<TString, TString>;

    public:
        TDomainList();
        TDomainList(const domainlists_proto::Cache& c);
        TDomainList(const TDomainList& o);
        TDomainList(TDomainList&& o) = default;
        TDomainList& operator=(const TDomainList& o) = default;
        TDomainList& operator=(TDomainList&& o) = default;

        // disk cache
        void Serialize(domainlists_proto::Cache& out) const;

        void DeleteDomain(const TString& id);
        void AddOrUpdateDomain(TDomain&& newDomain);

        const TDomain* FindById(const TString& id) const;
        const TDomain* FindByName(const TString& name) const;

        void Reserve(size_t res);
        size_t size() const;

        class TIterator {
        public:
            const TDomain* Next();

        private:
            TIterator(const TDomainList& parent);

            const TDomainList& Parent_;
            TDomlistById::const_iterator It_;
            friend class TDomainList;
        };

        TIterator GetIterator() const;

        void SetLogger(bool logging);

        // for tests
        bool operator==(const TDomainList& o) const;

    private:
        TDomlistById ListById_;
        TDomlistByName IndexByName_;
        bool Logging_ = false;
    };

    struct TDomainCache {
        TDomainList List;
        TString LastEventId;

        bool operator==(const TDomainCache& o) const {
            return List == o.List && LastEventId == o.LastEventId;
        }
    };
    using TDomainCachePtr = std::shared_ptr<TDomainCache>;
}
