#pragma once

#include "domain_list.h"

#include <util/generic/string.h>

namespace NPassport::NBb {
    class IDomainFetcher {
    public:
        class TResult {
        public:
            TResult() = default;
            TResult(const TDomainCachePtr cache, const TDomain* d)
                : Cache(cache)
                , Domain(d)
            {
            }

            explicit operator bool() const {
                return Domain;
            }

            TDomainCachePtr Cache;
            const TDomain* Domain = nullptr;
        };

        enum class EPolicy {
            MasterOnly,
            MasterOrAlias,
            ReplaceAliasWithMaster,
        };
        virtual ~IDomainFetcher() = default;

        virtual TResult FindById(const TString& domid, EPolicy policy = EPolicy::ReplaceAliasWithMaster) const = 0;
        virtual TResult FindInDb(const TString& domain, bool useDomid = false, EPolicy policy = EPolicy::ReplaceAliasWithMaster) const = 0;
    };
}
