#pragma once

#include "idomain_fetcher.h"

#include <passport/infra/libs/cpp/utils/log/global.h>

#include <util/generic/yexception.h>

namespace NPassport::NBb {
    class TNotImplementedDomainFetcher: public IDomainFetcher {
        TResult FindById(const TString& domid, EPolicy policy = EPolicy::ReplaceAliasWithMaster) const override {
            throw yexception() << "Calling findById method in artificial domain fetcher; domid: " << domid << "; policy: " << policy;
        }

        TResult FindInDb(const TString& domain, bool useDomid = false, EPolicy policy = EPolicy::ReplaceAliasWithMaster) const override {
            throw yexception() << "Calling findInDb method in artificial domain fetcher; domain: " << domain << "; useDomid: " << useDomid << "; EPolicy: " << policy;
        }
    };
}
