#pragma once

#include <passport/infra/libs/cpp/auth_core/gamma/gamma_keeper.h>
#include <passport/infra/libs/cpp/gamma_fetcher/iss_parts_fetcher.h>

#include <util/generic/string.h>

#include <memory>

namespace NPassport::NXml {
    class TConfig;
}

namespace NPassport::NBb::NGammas {
    class TFetcher {
    public:
        static NAuth::TGammaKeeperPtr CreateKeeper(NGammaFetcher::TIssPartFetcherPtr issPartsFetcher,
                                                   const NXml::TConfig& config,
                                                   const TString& xpath);

    public:
        static NAuth::EEnitityType GetType(const TString& type, const TString& path);

        static NAuth::TGammaKeeperSettings::TKeyspaces InitKeyspaces(const NXml::TConfig& config,
                                                                     const TString& xpath);
        static NAuth::TGammaKeeperSettings::TTimeBound InitTimeBounds(const NXml::TConfig& config,
                                                                      const TString& xpath);
        static NAuth::TGammaKeeperSettings::TSignedTypes InitSignedTypes(const NXml::TConfig& config,
                                                                         const TString& xpath);
    };
}
