#include "consumer_info.h"

#include <passport/infra/libs/cpp/utils/string/string_utils.h>

namespace NPassport::NBb {
    static const TString UNKNOWN = "_unknown_";
    TConsumerInfo::TConsumerInfo()
        : Name_(UNKNOWN)
    {
    }

    static const TString AUTH_SUFFIX_IP = "_IP";
    static const TString AUTH_SUFFIX_TVM2 = "_TVM2";
    TConsumerInfo::TConsumerInfo(std::shared_ptr<TConsumer> consumer,
                                 TString&& err,
                                 TConsumerInfo::EAuthType auth,
                                 EServiceTicketStatus serviceTicketStatus,
                                 ui32 tvmId)
        : Name_(UNKNOWN)
        , Consumer_(std::move(consumer))
        , Err_(std::move(err))
        , ServiceTicketStatus_(serviceTicketStatus)
    {
        const TString* suffix = nullptr;

        switch (auth) {
            case TConsumerInfo::EAuthType::Ip:
                suffix = &AUTH_SUFFIX_IP;
                break;
            case TConsumerInfo::EAuthType::Tvm2:
                suffix = &AUTH_SUFFIX_TVM2;
                break;
        }

        if (Consumer_) {
            Name_ = NUtils::CreateStr(Consumer_->GetName(), *suffix);
            TvmId_ = Consumer_->GetClientId();
        } else if (tvmId != 0) {
            Name_ = NUtils::CreateStr(UNKNOWN, "tvmid=", tvmId, AUTH_SUFFIX_TVM2);
            TvmId_ = tvmId;
        }
    }

    bool TConsumerInfo::IsOk() const {
        return Err_.empty() && Consumer_;
    }

    const TString& TConsumerInfo::GetName() const {
        return Name_;
    }

    const TString& TConsumerInfo::GetError() const {
        return Err_;
    }

    const TConsumer& TConsumerInfo::GetConsumer() const {
        Y_ENSURE(IsOk(), "we forget to check error");
        return *Consumer_;
    }

    const TConsumer* TConsumerInfo::GetOptionalConsumer() const {
        return Consumer_.get();
    }

    ui32 TConsumerInfo::GetTvmId() const {
        return TvmId_;
    }

    bool TConsumerInfo::IsServiceTicketBad() const {
        return ServiceTicketStatus_ == EServiceTicketStatus::Bad;
    }

    void TConsumerInfo::ClearError() {
        Err_.clear();
    }
}
