#pragma once

#include "consumer.h"

namespace NPassport::NBb {
    class TConsumerInfo {
    public:
        enum class EAuthType {
            Ip,
            Tvm2,
        };

        enum class EServiceTicketStatus {
            Bad,
            Unspecified,
        };

        TConsumerInfo();
        TConsumerInfo(std::shared_ptr<TConsumer> consumer,
                      TString&& err,
                      EAuthType auth,
                      EServiceTicketStatus serviceTicketStatus = EServiceTicketStatus::Unspecified,
                      ui32 tvmId = 0);

        bool IsOk() const;

        const TString& GetName() const;
        const TString& GetError() const;
        const TConsumer& GetConsumer() const;
        const TConsumer* GetOptionalConsumer() const;
        ui32 GetTvmId() const;

        bool IsServiceTicketBad() const;

        void ClearError();

    private:
        TString Name_;
        std::shared_ptr<TConsumer> Consumer_;
        TString Err_;
        EServiceTicketStatus ServiceTicketStatus_ = EServiceTicketStatus::Unspecified;
        ui32 TvmId_ = 0;
    };
}
