#pragma once

#include "consumer.h"

#include <passport/infra/daemons/blackbox/src/output/check_grants_result.h>

#include <passport/infra/libs/cpp/request/request.h>

#include <util/generic/string.h>

namespace NPassport::NCommon {
    class TRequest;
}

namespace NPassport::NBb {
    class TAttributesSettings;
    class TCheckGrantsResult;

    class TGrantsChecker {
    public:
        TGrantsChecker(const NCommon::TRequest& request,
                       const TConsumer& consumer,
                       bool throwOnError);
        TGrantsChecker(TGrantsChecker&&) = default;

        void CheckMethodAllowed(TBlackboxMethods::EMethod method);
        void CheckNotEmptyArgAllowed(const TString& arg, TBlackboxFlags::EFlag flag);
        void CheckHasArgAllowed(const TString& arg, TBlackboxFlags::EFlag flag);
        void CheckArgIsTrue(const TString& arg, TBlackboxFlags::EFlag flag);

        // expected signature: bool isAllowed(const TString& value);
        template <typename Func>
        void CheckArg(const TString& arg, Func isAllowed) {
            const TString& value = Request_.GetArg(arg);

            if (isAllowed(value)) {
                return;
            }

            ProcessArgWithValue(arg, value);
        }

        void Add(TString&& error);

        const NCommon::TRequest& GetRequest();
        const TConsumer& GetConsumer();
        const TCheckGrantsResult& GetResult() const;
        TCheckGrantsResult Extract();

    private:
        void ProcessArgWithValue(const TString& key, const TString& value);
        void ProcessError(TString&& error);

    private:
        const NCommon::TRequest& Request_;
        const TConsumer& Consumer_;
        const bool ThrowOnError_;

        TCheckGrantsResult Result_;
    };
}
