#pragma once

#include <passport/infra/daemons/blackbox/src/ip/ipacl_loader.h>

#include <passport/infra/libs/cpp/utils/atomic.h>

namespace NPassport::NBb {

    // Full IP grants configuration, as above + reading the grants configuration
    class TIpGrants: public TIpAclLoader {
    public:
        TIpGrants(const TString& path, TDuration timeout);

        TString PrintEntryInfo(const TConsumer& consumer) const override;

        ui64 GetParsingErrors() const;

    protected:
        std::shared_ptr<TIpAclMap<TConsumer>> Parse(const TStringBuf fileBody, const time_t mtime) override;

    private:
        NUtils::TAtomicNum<> ParsingErrors_;
    };
}
