#pragma once

#include "consumer.h"

#include <passport/infra/libs/cpp/utils/atomic.h>
#include <passport/infra/libs/cpp/utils/shared_state.h>

#include <contrib/libs/rapidjson/include/rapidjson/document.h>

#include <util/datetime/base.h>
#include <util/generic/string.h>

#include <memory>
#include <unordered_map>

namespace NPassport::NUtils {
    class TFileLoader;
    class TIpAddr;
}

namespace NPassport::NBb {

    template <typename T>
    class TIpAclMap;

    using TClientId = ui32;

    class TTvmGrants {
    public:
        TTvmGrants(const TString& path, TDuration period);
        ~TTvmGrants();

        // CAUTION: returned consumer_ is not always valid, need to check err_, see comment below
        struct TFindResult {
            std::shared_ptr<TConsumer> Consumer;
            TString Err; // do not forget to check it: valid consumer has empty error
        };

        TFindResult FindConsumer(const TClientId clientId, const NUtils::TIpAddr& ip) const;
        time_t GetMTime() const;

        ui64 GetParsingErrors() const;

    private:
        struct TConsumerInfo {
            std::shared_ptr<TIpAclMap<TConsumer>> IpMap;
            std::shared_ptr<TConsumer> Consumer;
        };

        struct TStorage {
            std::unordered_map<TClientId, TConsumerInfo> Map;
            time_t Mtime = 0;
        };

        static std::shared_ptr<TStorage> Parse(const TStringBuf fileBody, const time_t mtime);
        void Update(const TStringBuf fileBody, const time_t mtime);

        static std::shared_ptr<TConsumer> ParseConsumer(const rapidjson::Value& obj, const TString& name, NTvmAuth::TTvmId clientId);
        static bool GetBool(const rapidjson::Value& obj, const TString& key);
        static TString GetString(const rapidjson::Value& arr);
        static void ParseAttrs(TConsumer& consumer, const rapidjson::Value& obj, const char* section, TConsumer::ERank rank);
        static void LogAttrError(const TConsumer& consumer, const char* section, const TString& value, const char* msg);
        static std::shared_ptr<TIpAclMap<TConsumer>> ParseIp(std::shared_ptr<TConsumer> consumer, rapidjson::Value& doc);

    private:
        const TString Path_;
        NUtils::TSharedState<TStorage> ConsumerMap_;
        NUtils::TAtomicNum<> ParsingErrors_;

        // must be last member
        std::unique_ptr<NUtils::TFileLoader> FileLoader_;
    };
}
