#pragma once

#include <passport/infra/daemons/blackbox/src/misc/db_profile.h>

#include <util/generic/string.h>

#include <memory>
#include <vector>

namespace NPassport::NCommon {
    class TRequest;
}
namespace NPassport::NBb {
    class TAccountChunk;
    class TGrantsChecker;
    class TDbFieldsConverter;
    class TDbFieldsResult;

    class TAccountHelper {
    public:
        static const std::vector<TString> ALL_ALIASES;

        TAccountHelper(TDbFieldsConverter& conv, const NCommon::TRequest& request);

        static void CheckGrants(TGrantsChecker& checker);

        std::unique_ptr<TAccountChunk> Result(const TDbProfile* profile) const;

    private:
        const TString& GetLoginField(const TDbProfile* profile) const;

        bool HiddenAliasesAsked_ = false;
        bool AreAliasesRequired_ = false;
        const TDbFieldsResult* Regname_;
        std::vector<TDbIndex> LoginAliases_;
        TDbIndex HavePwd_, HaveHint_, EnablePhoneAlias_;
        std::vector<TString> Aliases_;
    };

}
