#pragma once

#include <passport/infra/daemons/blackbox/src/grants/consumer.h>

#include <util/generic/string.h>

#include <map>
#include <memory>

namespace NPassport::NCommon {
    class TRequest;
}

namespace NPassport::NBb {
    class TAttributesChunk;
    class TAttributesSettings;
    class TDbFetcher;
    class TDbProfile;
    class TGrantsChecker;

    using TDbIndex = int;

    class TAttributesHelper {
    public:
        TAttributesHelper(TDbFetcher& fetcher, const TAttributesSettings& settings, const NCommon::TRequest& req);

        static void CheckGrants(TConsumer::ERank rank,
                                const TAttributesSettings& settings,
                                TGrantsChecker& checker);

        std::unique_ptr<TAttributesChunk> Result(const TDbProfile* profile) const;

    private:
        std::map<TString, TDbIndex> Attrs_;
        const TAttributesSettings& AttrSettings_;
    };
}
