#pragma once

#include "account_helper.h"
#include "billing_features_helper.h"
#include "dbfields_helper.h"
#include "display_name_helper.h"
#include "family_info_helper.h"
#include "karma_helper.h"
#include "plus_subscriber_state_helper.h"
#include "public_id_helper.h"

#include <passport/infra/daemons/blackbox/src/grants/consumer.h>

#include <memory>
#include <vector>

namespace NPassport::NCommon {
    class TRequest;
}
namespace NPassport::NBb {
    class TAttributesHelper;
    class TAttributesSettings;
    class TBaseResult;
    class TBlackboxImpl;
    class TGrantsChecker;
    class TDbFieldsConverter;
    class TDbFieldsSettings;
    class TDbProfile;
    class TEmailAttrsHelper;
    class TPhoneAttrsHelper;
    class TValidator;
    class TUserMessagesHelper;
    class TWebauthnAttrsHelper;

    class TBaseResultHelper {
    public:
        TBaseResultHelper(TDbFieldsConverter& conv, const TBlackboxImpl& bb, const NCommon::TRequest& req);
        ~TBaseResultHelper();

        static void CheckGrants(const TDbFieldsSettings& dbfieldSettings,
                                const TAttributesSettings& attrSettings,
                                TConsumer::ERank rank,
                                TGrantsChecker& checker);
        static void CheckPhoneOperationsGrants(TGrantsChecker& checker);
        static void CheckPhoneBindingsGrants(TGrantsChecker& checker);

        static EPhoneBindingsType GetPhoneBindingsType(const NCommon::TRequest& request);

        void FillResults(TBaseResult& result, const TDbProfile* profile) const;

    private:
        TKarmaHelper Karma_;
        TDbFieldsHelper DbFields_;
        TDisplayNameHelper DisplayName_;
        TAccountHelper Account_;
        TBillingFeaturesHelper BillingFeatures_;
        TPlusSubscriberStateHelper PlusSubscriberState_;
        TPublicIdHelper PublicId_;
        TFamilyInfoHelper FamilyInfo_;

        std::unique_ptr<TAttributesHelper> Attrs_;
        std::unique_ptr<TValidator> Validator_;
        std::unique_ptr<TPhoneAttrsHelper> PhoneAttrs_;
        std::unique_ptr<TEmailAttrsHelper> EmailAttrs_;
        std::unique_ptr<TWebauthnAttrsHelper> WebauthnAttrs_;
        bool NeedPhoneOperations_;
        bool NeedPhoneBindings_;
    };
}
