#include "dbfields_helper.h"

#include <passport/infra/daemons/blackbox/src/blackbox_impl.h>
#include <passport/infra/daemons/blackbox/src/grants/grants_checker.h>
#include <passport/infra/daemons/blackbox/src/misc/dbfields_converter.h>
#include <passport/infra/daemons/blackbox/src/misc/dbfields_settings.h>
#include <passport/infra/daemons/blackbox/src/misc/exception.h>
#include <passport/infra/daemons/blackbox/src/misc/strings.h>
#include <passport/infra/daemons/blackbox/src/misc/utils.h>
#include <passport/infra/daemons/blackbox/src/output/dbfields_chunk.h>

#include <passport/infra/libs/cpp/request/request.h>
#include <passport/infra/libs/cpp/utils/string/split.h>

namespace NPassport::NBb {
    TDbFieldsHelper::TDbFieldsHelper(TDbFieldsConverter& conv,
                                     const NCommon::TRequest& req) {
        DbfieldNames_ = NUtils::NormalizeListValue(req.GetArg(TStrings::DBFIELDS), ",");
        conv.AddDbFields(DbfieldNames_, DbfieldValues_);
    }

    std::unique_ptr<TDbFieldsChunk> TDbFieldsHelper::Result(const TDbProfile* profile) const {
        std::unique_ptr<TDbFieldsChunk> dbchunk = std::make_unique<TDbFieldsChunk>();

        dbchunk->Fields.reserve(DbfieldNames_.size());
        for (size_t idx = 0; idx < DbfieldValues_.size(); ++idx) {
            TDbFieldsChunk::TField field;
            field.Name = DbfieldNames_.at(idx);

            TDbFieldsResult* res = DbfieldValues_.at(idx);
            field.Value = res ? res->Value(profile) : TStrings::EMPTY;

            dbchunk->Fields.push_back(std::move(field));
        }

        return dbchunk;
    }

    void TDbFieldsHelper::CheckGrants(TConsumer::ERank rank,
                                      const TDbFieldsSettings& settings,
                                      TGrantsChecker& checker) {
        NUtils::Transform(checker.GetRequest().GetArg(TStrings::DBFIELDS), ',', [&](TStringBuf buf) {
            NUtils::Trim(buf);
            if (buf.empty()) {
                return;
            }

            const TString field(buf);
            if (settings.RequiresGrant(field) && !checker.GetConsumer().IsFieldAllowed(field, rank)) {
                checker.Add(NUtils::CreateStr("no grants for dbfield '", field, "'"));
            }
        });
    }
}
