#pragma once

#include <passport/infra/daemons/blackbox/src/grants/consumer.h>

#include <util/generic/string.h>

#include <memory>
#include <vector>

namespace NPassport::NCommon {
    class TRequest;
}

namespace NPassport::NBb {
    class TGrantsChecker;
    class TDbFieldsChunk;
    class TDbFieldsConverter;
    class TDbFieldsResult;
    class TDbFieldsSettings;
    class TDbProfile;

    class TDbFieldsHelper {
    public:
        TDbFieldsHelper(TDbFieldsConverter& conv,
                        const NCommon::TRequest& req);

        std::unique_ptr<TDbFieldsChunk> Result(const TDbProfile* profile) const;

        static void CheckGrants(TConsumer::ERank rank,
                                const TDbFieldsSettings& settings,
                                TGrantsChecker& checker);

    private:
        std::vector<TString> DbfieldNames_;
        std::vector<TDbFieldsResult*> DbfieldValues_;
    };
}
