#pragma once

#include <passport/infra/daemons/blackbox/src/misc/db_fetcher.h>

#include <util/generic/string.h>

#include <memory>
#include <optional>

namespace NPassport::NCommon {
    class TRequest;
}
namespace NPassport::NBb {
    class TGrantsChecker;
    class TDbFieldsConverter;
    class TDbFieldsResult;
    class TDbProfile;
    class TDisplayNameChunk;
    class TPublicNameData;

    class TDisplayNameBuilder {
    public:
        TDisplayNameBuilder(int firstName, int lastName);

        TString BuildDisplayName(const TDbProfile* profile, const TString& format, const TString& regname) const;

    private:
        static void AppendPddUsername(const TDbProfile* profile, const TString& regname, TString& result);

        static void AppendDbValue(const TDbProfile* profile, TDbIndex idx, TString& result);

        int FirstName_;
        int LastName_;
    };

    class TDisplayNameHelper {
    public:
        TDisplayNameHelper(TDbFieldsConverter& conv,
                           const NCommon::TRequest& request,
                           time_t fullFioStartTime,
                           time_t publicProfileProtectionStartTime);

        static void CheckGrants(TGrantsChecker& checker);

        std::unique_ptr<TDisplayNameChunk> Result(const TDbProfile* profile) const;

        static bool DisplayNameEmpty(const TString& value);
        static TString BuildPublicName(TStringBuf firstName, TStringBuf lastName, bool showFIO);
        static TString BuildIncognitoName(const TString& language, const TString& uid);
        static TString SuggestPublicName(TStringBuf firstName, TStringBuf lastName);

    public: // for tests
        static const TString& GetPhoneAttr(const TDbProfile* profile, const TString& attr);
        std::optional<TPublicNameData> GetPublicName(const TDbProfile* profile,
                                                     const TString& name) const;
        bool GetPublicDataFlag(const TDbProfile* profile, int attr) const;

    private:
        static bool ParseSocial(const TString& data,
                                TString& profileId,
                                TString& provider,
                                TString& displayName);

        static TString GenerateRedirectTarget(const TString& uid,
                                              const TString& id);

        const TDbFieldsResult* Regname_ = nullptr;
        int Login_ = -1;
        int DisplayName_ = -1;
        int Avatar_ = -1;
        bool IsDisplayNameEmptinessRequired_ = false;
        int FirstName_ = -1;
        int LastName_ = -1;
        bool IsPublicNameRequired_ = false;
        int DontUseDisplaynameAsPublicname_ = -1;
        int ShowFioInPublicName_ = -1;
        int RegistrationTime_ = -1;
        int PublicProfileAllowed_ = -1;
        int PublicProfile3PartyCanUse_ = -1;
        const time_t FullFioStartTime_;
        const time_t PublicProfileProtectionStartTime_;
        int IsVerified_ = -1;
        int Language_ = -1;
    };

}
