#include "family_info_helper.h"

#include <passport/infra/daemons/blackbox/src/methods/family_info.h>
#include <passport/infra/daemons/blackbox/src/misc/db_fetcher.h>
#include <passport/infra/daemons/blackbox/src/misc/strings.h>
#include <passport/infra/daemons/blackbox/src/misc/utils.h>
#include <passport/infra/daemons/blackbox/src/output/family_info_chunk.h>

#include <passport/infra/libs/cpp/request/request.h>
#include <passport/infra/libs/cpp/utils/string/string_utils.h>

namespace NPassport::NBb {
    TFamilyInfoHelper::TFamilyInfoHelper(TDbFetcher& fetcher, const NCommon::TRequest& req) {
        if (!TUtils::GetBoolArg(req, TStrings::GET_FAMILY_INFO)) {
            return;
        }

        fetcher.AddFamilyInfo();
        NeedFamilyInfo_ = true;
    }

    std::unique_ptr<TFamilyInfoChunk> TFamilyInfoHelper::Result(const TDbProfile* profile) const {
        if (!profile || !NeedFamilyInfo_) {
            return {};
        }

        std::unique_ptr<TFamilyInfoChunk> res = std::make_unique<TFamilyInfoChunk>();

        if (!profile->FamilyInfo()) {
            // user is not a member of any family
            return res;
        }

        res->FamilyId = TFamilyInfoProcessor::FromInternalFamilyId(profile->FamilyInfo()->FamilyId);
        res->AdminUid = profile->FamilyInfo()->AdminUid;

        return res;
    }
}
