#pragma once

#include <util/generic/string.h>

#include <memory>
#include <vector>

namespace NPassport::NCommon {
    class TRequest;
}
namespace NPassport::NBb {
    class TAttributesChunk;
    class TGrantsChecker;
    class TOAuthBaseFetcher;
    class TOAuthTokenInfo;

    class TOAuthAttrsHelper {
    public:
        TOAuthAttrsHelper(TOAuthBaseFetcher& fetcher, const NCommon::TRequest& request);

        static void CheckGrants(TGrantsChecker& checker);

        std::unique_ptr<TAttributesChunk> TokenAttrsChunk(const TOAuthTokenInfo* info) const;
        std::unique_ptr<TAttributesChunk> ClientAttrsChunk(const TOAuthTokenInfo* info) const;

    private:
        using TAttrNamesList = std::vector<TString>;

        bool AllTokenAttrs_ = false;
        bool AllClientAttrs_ = false;

        TAttrNamesList TokenAttrs_;
        TAttrNamesList ClientAttrs_;
    };

}
