#include "partitions_helper.h"

#include <passport/infra/daemons/blackbox/src/grants/grants_checker.h>
#include <passport/infra/daemons/blackbox/src/misc/exception.h>
#include <passport/infra/daemons/blackbox/src/misc/partitions.h>
#include <passport/infra/daemons/blackbox/src/misc/strings.h>

#include <passport/infra/libs/cpp/utils/string/split.h>
#include <passport/infra/libs/cpp/utils/string/string_utils.h>

namespace NPassport::NBb {
    std::vector<ui64> TPartitionsHelper::ParsePartitionArg(const TPartitionsSettings& partitionsSettings,
                                                           const NCommon::TRequest& request,
                                                           const TSettings& settings) {
        std::vector<TString> partitions = NUtils::NormalizeListValue(request.GetArg(TStrings::PARTITION), ",");
        if (partitions.empty()) {
            return {partitionsSettings.GetDefaultPartitionId()};
        }

        if (settings.ForbidArray && partitions.size() != 1) {
            throw TBlackboxError(TBlackboxError::EType::InvalidParams)
                << "Array is not allowed in '" << TStrings::PARTITION << "' param for method=" << settings.Method;
        }

        if (settings.ForbidNonDefault && (partitions.size() != 1 || !partitionsSettings.IsDefaultPartition(partitions[0]))) {
            throw TBlackboxError(TBlackboxError::EType::InvalidParams)
                << "Partitions are not supported for method=" << settings.Method;
        }

        std::vector<ui64> res;
        res.reserve(partitions.size());
        for (const TString& partition : partitions) {
            res.push_back(partitionsSettings.GetPartitionId(partition));
        }

        return res;
    }

    void TPartitionsHelper::CheckGrants(const TPartitionsSettings& settings,
                                        TGrantsChecker& checker) {
        const TString& partitions = checker.GetRequest().GetArg(TStrings::PARTITION);

        NUtils::Transform(partitions, ',', [&](TStringBuf partition) {
            NUtils::Trim(partition);
            const bool needGrant = !settings.IsDefaultPartition(partition);
            if (needGrant && !checker.GetConsumer().IsPartitionAllowed(partition)) {
                checker.Add(NUtils::CreateStr("no grants for partition '", partition, "'"));
            }
        });
    }
}
